local cockpit = folder.."../../../Cockpit/Scripts/"
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")

local res = external_profile("Config/Input/Aircrafts/common_joystick_binding.lua")

join(res.keyCommands,{

---------------------------------------------
-- Cheat ------------------------------------
---------------------------------------------
{	down = iCommandEnginesStart,													name = _('Auto Start'),		category = _('Cheat')},
{	down = iCommandEnginesStop,														name = _('Auto Stop'),		category = _('Cheat')},
{	down = device_commands.Button_10,	cockpit_device_id = 0,	value_down = 1.0,	name = _('Recorder On'),	category = _('Cheat')},
{	down = device_commands.Button_11,	cockpit_device_id = 0,	value_down = 1.0,	name = _('Recorder Off'),	category = _('Cheat')},

---------------------------------------------
-- General ----------------------------------
---------------------------------------------
{	down = iCommandCockpitShowPilotOnOff, name = _('Show pilot body'), category = _('General')},

---------------------------------------------
-- View Cockpit -----------------------------
---------------------------------------------
{	down = iCommandToggleMirrors,								name = _('Toggle Mirrors'),							category = _('View Cockpit')},
{	down = 3255,	cockpit_device_id  = 0,	value_down = 1.0,	name = _('Toggle Flashlight Color - Red/White'),	category = _('View Cockpit')},

---------------------------------------------
-- Flight Control ---------------------------
---------------------------------------------
{	down = iCommandPlaneUpStart,			up = iCommandPlaneUpStop,			name = _('Aircraft Pitch Down'),						category = _('Flight Control')},
{	down = iCommandPlaneDownStart,			up = iCommandPlaneDownStop,			name = _('Aircraft Pitch Up'),							category = _('Flight Control')},
{	down = iCommandPlaneLeftStart,			up = iCommandPlaneLeftStop,			name = _('Aircraft Bank Left'),							category = _('Flight Control')},
{	down = iCommandPlaneRightStart,			up = iCommandPlaneRightStop,		name = _('Aircraft Bank Right'),						category = _('Flight Control')},
{	down = iCommandPlaneLeftRudderStart,	up = iCommandPlaneLeftRudderStop,	name = _('Aircraft Rudder Left'),						category = _('Flight Control')},
{	down = iCommandPlaneRightRudderStart,	up = iCommandPlaneRightRudderStop,	name = _('Aircraft Rudder Right'),						category = _('Flight Control')},

---------------------------------------------
-- Stick ------------------------------------
---------------------------------------------
{	down = gear_commands.NoseSteering,			up = gear_commands.NoseSteering,			cockpit_device_id = devices.GEAR_INTERFACE,		value_down =  1, value_up = 0,	name = _('Nosewheel Steering Button'),										category = {_('Stick')}},
{	down = control_commands.AileronLimitOff_EXT,up = control_commands.AileronLimitOff_EXT,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down =  1, value_up = 0,	name = _('Aileron Limiter (Hold to turn off)'),								category = {_('Stick'), _('Flight Control')}},
{	down = iCommandPlanePickleOn,				up = iCommandPlanePickleOff,																								name = _('Weapon Release Button'),											category = {_('Stick')}},
{	down = weapons_commands.TrgFirstDetent,		up = weapons_commands.TrgFirstDetent,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down =  1, value_up = 0,	name = _('Gun Trigger - FIRST DETENT'), 									category = {_('Stick')}},
{	down = iCommandPlaneFire,					up = iCommandPlaneFireOff, 																									name = _('Gun Trigger - SECOND DETENT (Press to shoot)'),					category = {_('Stick')}},
{	down = asg31_commands.DgMode,				up = asg31_commands.DgMode,					cockpit_device_id = devices.AN_ASG31,			value_down = -1, value_up = 0,	name = _('Dogfight/Resume Search Switch - FORWARD (DM)'),					category = {_('Stick')}},
{	down = asg31_commands.ResumeSearch,			up = asg31_commands.ResumeSearch,			cockpit_device_id = devices.AN_ASG31,			value_down =  1, value_up = 0,	name = _('Dogfight/Resume Search Switch - CENTER-PRESS (RESUME SEARCH)'),	category = {_('Stick')}},
{	down = asg31_commands.DgMode,				up = asg31_commands.DgMode,					cockpit_device_id = devices.AN_ASG31,			value_down =  1, value_up = 0,	name = _('Dogfight/Resume Search Switch - AFT (DG)'),						category = {_('Stick')}},
{	down = control_commands.PitchDamperCutoff,	up = control_commands.PitchDamperCutoff,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down =  1, value_up = 0,	name = _('Pitch Damper Cutoff Switch'),										category = {_('Stick')}},
{	pressed = iCommandPlaneTrimUp,				up = iCommandPlaneTrimStop,																									name = _('Elevator Trimmer Switch - PUSH(DESCEND)'),						category = {_('Stick'), _('Flight Control')}},
{	pressed = iCommandPlaneTrimDown,			up = iCommandPlaneTrimStop,																									name = _('Elevator Trimmer Switch - PULL(CLIMB)'),							category = {_('Stick'), _('Flight Control')}},
{	pressed = iCommandPlaneTrimLeft,			up = iCommandPlaneTrimStop,																									name = _('Aileron Trimmer Switch - LEFT WING DOWN'),						category = {_('Stick'), _('Flight Control')}},
{	pressed = iCommandPlaneTrimRight,			up = iCommandPlaneTrimStop,																									name = _('Aileron Trimmer Switch - RIGHT WING DOWN'),						category = {_('Stick'), _('Flight Control')}},

---------------------------------------------
-- Throttle Quadrant ------------------------
---------------------------------------------
{	down = iCommandThrottleIncrease,		up = iCommandThrottleStop,			name = _('Throttle Smoothly (Both) - Increase'),		category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandThrottleDecrease,		up = iCommandThrottleStop,			name = _('Throttle Smoothly (Both) - Decrease'),		category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandThrottle1Increase,		up = iCommandThrottle1Stop,			name = _('Throttle Smoothly (Left) - Increase'),		category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandThrottle1Decrease,		up = iCommandThrottle1Stop,			name = _('Throttle Smoothly (Left) - Decrease'),		category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandThrottle2Increase,		up = iCommandThrottle2Stop,			name = _('Throttle Smoothly (Right) - Increase'),		category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandThrottle2Decrease,		up = iCommandThrottle2Stop,			name = _('Throttle Smoothly (Right) - Decrease'),		category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandPlaneAUTIncreaseRegime,										name = _('Throttle Step (Both) - Increase'),			category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandPlaneAUTDecreaseRegime,										name = _('Throttle Step (Both) - Decrease'),			category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandPlaneAUTIncreaseRegimeLeft,									name = _('Throttle Step (Left) - Increase'),			category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandPlaneAUTDecreaseRegimeLeft,									name = _('Throttle Step (Left) - Decrease'),			category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandPlaneAUTIncreaseRegimeRight,									name = _('Throttle Step (Right) - Increase'),			category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandPlaneAUTDecreaseRegimeRight,									name = _('Throttle Step (Right) - Decrease'),			category = {_('Throttle Quadrant'), _('Flight Control')}},
--
{combos = {{key = "JOY_BTN21"}},		down = control_commands.ThrottleRange_EXT, 						cockpit_device_id = devices.CONTROL_INTERFACE, 	value_down = 1,					name = _('Throttle Range (Press to change)'),				category = {_('Throttle Quadrant'), _('Flight Control')}},
{	down = iCommandLeftEngineStart,																													name = _('Throttle (Left) - IDLE'),							category = _('Throttle Quadrant')},
{	down = iCommandLeftEngineStop,																													name = _('Throttle (Left) - OFF'),							category = _('Throttle Quadrant')},
{	down = iCommandRightEngineStart,																												name = _('Throttle (Right) - IDLE'),						category = _('Throttle Quadrant')},
{	down = iCommandRightEngineStop,																													name = _('Throttle (Right) - OFF'),							category = _('Throttle Quadrant')},
{combos = {{key = "JOY_BTN30"}},		down = iCommandLeftEngineStop, 		up = iCommandLeftEngineStart,												value_down = 1, value_up = 1,	name = _("Throttle (Left) - OFF/IDLE"),  					category = _('Throttle Quadrant')},
{combos = {{key = "JOY_BTN29"}},		down = iCommandRightEngineStop,		up = iCommandRightEngineStart,												value_down = 1, value_up = 1,	name = _("Throttle (Right) - OFF/IDLE"),  					category = _('Throttle Quadrant')},
{	down = iCommandPlaneAirBrake,																													name = _('Speed Brake Switch - Cycle'),						category = _('Throttle Quadrant')},
{	down = iCommandPlaneAirBrakeOn,																													name = _('Speed Brake Switch - Step Aft'),					category = _('Throttle Quadrant')},
{	down = iCommandPlaneAirBrakeOff,																												name = _('Speed Brake Switch - Step Fwd'),					category = _('Throttle Quadrant')},
{	down = control_commands.SpdBrk,									cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = -1,				name = _('Speed Brake Switch - OUT'),						category = _('Throttle Quadrant')},
{	down = control_commands.SpdBrk,									cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 0,					name = _('Speed Brake Switch - OFF'),						category = _('Throttle Quadrant')},
{	down = control_commands.SpdBrk,									cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1,					name = _('Speed Brake Switch - IN'),						category = _('Throttle Quadrant')},
{combos = {{key = "JOY_BTN8"}},			down = control_commands.SpdBrk,	up = control_commands.SpdBrk,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down =-1.0, value_up = 0,	name = _('Speed Brake Switch - OUT/OFF'),					category = {_('Throttle Quadrant'),_('HOTAS')}},
{combos = {{key = "JOY_BTN7"}},			down = control_commands.SpdBrk,	up = control_commands.SpdBrk,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0, value_up = 0,	name = _('Speed Brake Switch - OFF/IN'),					category = {_('Throttle Quadrant'),_('HOTAS')}},
{	down = iCommandPlaneFlaps,																														name = _('Flap Lever - Cycle'),								category = _('Throttle Quadrant')},
{	down = iCommandPlaneFlapsOn,																													name = _('Flap Lever - Step Down'),							category = _('Throttle Quadrant')},
{	down = iCommandPlaneFlapsOff,																													name = _('Flap Lever - Step Up'),							category = _('Throttle Quadrant')},
{	down = control_commands.FlapLever,								cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0,				name = _('Flap Lever - EMER UP'),							category = _('Throttle Quadrant')},
{	down = control_commands.FlapLever,								cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 0.0,				name = _('Flap Lever - THUMB SW'),							category = _('Throttle Quadrant')},
{	down = control_commands.FlapLever,								cockpit_device_id = devices.CONTROL_INTERFACE,	value_down =-1.0,				name = _('Flap Lever - FULL'),								category = _('Throttle Quadrant')},
{combos = {{key = "JOY_BTN22"}},		down = control_commands.FlapLever,	up = control_commands.FlapLever,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0, value_up = 0,	name = _('Flap Lever - EMER UP/THUMB SW'),			category = {_('Throttle Quadrant'),_('HOTAS')}},
{combos = {{key = "JOY_BTN23"}},		down = control_commands.FlapLever,	up = control_commands.FlapLever,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down =-1.0, value_up = 0,	name = _('Flap Lever - THUMB SW/FULL'),				category = {_('Throttle Quadrant'),_('HOTAS')}},
{	down = control_commands.FlapSwitch_EXT,							cockpit_device_id = devices.CONTROL_INTERFACE,	value_down =  0,				name = _('Flap Switch - Cycle'),							category = _('Throttle Quadrant')},
{	down = control_commands.FlapSwitch_EXT,							cockpit_device_id = devices.CONTROL_INTERFACE,	value_down =  1,				name = _('Flap Switch - Step Fwd'),							category = _('Throttle Quadrant')},
{	down = control_commands.FlapSwitch_EXT,							cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = -1,				name = _('Flap Switch - Step Aft'),							category = _('Throttle Quadrant')},
{	down = control_commands.FlapSwitch,								cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0,				name = _('Flap Switch - UP'),								category = _('Throttle Quadrant')},
{	down = control_commands.FlapSwitch,								cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 0.0,				name = _('Flap Switch - FIXED'),							category = _('Throttle Quadrant')},
{	down = control_commands.FlapSwitch,								cockpit_device_id = devices.CONTROL_INTERFACE,	value_down =-1.0,				name = _('Flap Switch - AUTO'),								category = _('Throttle Quadrant')},
{combos = {{key = "JOY_BTN9"}},			down = control_commands.FlapSwitch,	up = control_commands.FlapSwitch,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0, value_up = 0,	name = _('Flap Switch - UP/FIXED'),					category = {_('Throttle Quadrant'),_('HOTAS')}},
{combos = {{key = "JOY_BTN10"}},		down = control_commands.FlapSwitch,	up = control_commands.FlapSwitch,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down =-1.0, value_up = 0,	name = _('Flap Switch - AUTO/FIXED'),				category = {_('Throttle Quadrant'),_('HOTAS')}},
{combos = {{key = "JOY_BTN12"}},		down = cmds_commands.FlChButton, 	up = cmds_commands.FlChButton,		cockpit_device_id = devices.CMDS,				value_down = 1.0, value_up = 0,	name = _('Flare-Chaff Button'),						category = _('Throttle Quadrant')},
{combos = {{key = "JOY_BTN11"}},		down = weapons_commands.MslUncage,	up = weapons_commands.MslUncage,	cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0, value_up = 0,	name = _('Missile Uncage Switch'),					category = _('Throttle Quadrant')},
{	down = asg31_commands.SightCage, 	up = asg31_commands.SightCage,		cockpit_device_id = devices.AN_ASG31,			value_down = 1.0, value_up = 0,	name = _('AN/ASG-31 Sight Cage Switch'),			category = {_('Throttle Quadrant'), _('AN/ASG-31 Sight')}},

---------------------------------------------
-- Systems ----------------------------------
---------------------------------------------
{	down = iCommandPlaneWheelBrakeOn,		up = iCommandPlaneWheelBrakeOff,		name = _('Wheel Brake - ON/OFF'),				category = _('Systems')},
{	down = iCommandPlaneWheelBrakeLeftOn,	up = iCommandPlaneWheelBrakeLeftOff,	name = _('Wheel Brake Left - ON/OFF'),			category = _('Systems')},
{	down = iCommandPlaneWheelBrakeRightOn,	up = iCommandPlaneWheelBrakeRightOff,	name = _('Wheel Brake Right - ON/OFF'),			category = _('Systems')},
{	down = iCommandPlaneFonar, 														name = _('Canopy - OPEN/CLOSE'),				category = _('Systems')},
{	down = iCommandPlaneEject,														name = _('Eject (3 times)'),					category = _('Systems')},
{	down = cpt_commands.SeatAdjustment_Dn,	up = cpt_commands.SeatAdjustment_Dn,	cockpit_device_id = devices.CPT_MECH, value_down =  -1, value_up = 0,	name = _('Seat Adjust Switch - DOWN'),	category = _('Systems')},
{	down = cpt_commands.SeatAdjustment_Up,	up = cpt_commands.SeatAdjustment_Up,	cockpit_device_id = devices.CPT_MECH, value_down =  1, value_up = 0,	name = _('Seat Adjust Switch - UP'),	category = _('Systems')},

---------------------------------------------
-- AN/ASG-31 Sight --------------------------
---------------------------------------------
{	down = asg31_commands.ModeSelector_EXT,		cockpit_device_id = devices.AN_ASG31,			value_down = -1.0,		name = _('AN/ASG-31 Sight Mode Selector - CCW/Left'),				category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.ModeSelector_EXT,		cockpit_device_id = devices.AN_ASG31,			value_down =  1.0,		name = _('AN/ASG-31 Sight Mode Selector - CW/Right'),				category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.ModeSelector,			cockpit_device_id = devices.AN_ASG31,			value_down = 0.0,		name = _('AN/ASG-31 Sight Mode Selector - OFF'),					category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.ModeSelector,			cockpit_device_id = devices.AN_ASG31,			value_down = 0.1,		name = _('AN/ASG-31 Sight Mode Selector - MSL'),					category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.ModeSelector,			cockpit_device_id = devices.AN_ASG31,			value_down = 0.2,		name = _('AN/ASG-31 Sight Mode Selector - A/A1 GUNS'),				category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.ModeSelector,			cockpit_device_id = devices.AN_ASG31,			value_down = 0.3,		name = _('AN/ASG-31 Sight Mode Selector - A/A2 GUNS'),				category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.ModeSelector,			cockpit_device_id = devices.AN_ASG31,			value_down = 0.4,		name = _('AN/ASG-31 Sight Mode Selector - MAN'),					category = _('AN/ASG-31 Sight')},
{	pressed = asg31_commands.RetIntensity_EXT,	cockpit_device_id = devices.AN_ASG31,			value_pressed = -0.2,	name = _('AN/ASG-31 Sight Reticle Intensity Knob - CCW/Decrease'),	category = _('AN/ASG-31 Sight')},
{	pressed = asg31_commands.RetIntensity_EXT,	cockpit_device_id = devices.AN_ASG31,			value_pressed =  0.2,	name = _('AN/ASG-31 Sight Reticle Intensity Knob - CW/Increase'),	category = _('AN/ASG-31 Sight')},
{	pressed = asg31_commands.RetDepression_EXT,	cockpit_device_id = devices.AN_ASG31,			value_pressed = -0.2,	name = _('AN/ASG-31 Sight Reticle Depression Knob - CCW/Decrease'),	category = _('AN/ASG-31 Sight')},
{	pressed = asg31_commands.RetDepression_EXT,	cockpit_device_id = devices.AN_ASG31,			value_pressed =  0.2,	name = _('AN/ASG-31 Sight Reticle Depression Knob - CW/Increase'),	category = _('AN/ASG-31 Sight')},
{	down = intlights_commands.PnlLt_button_EXT,	cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_down = 1.0,		name = _('AN/ASG-31 Sight Panel Light Button - ON/OFF'),			category = _('AN/ASG-31 Sight')},
{	down = intlights_commands.PnlLt_button,		cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_down = 0.0,		name = _('AN/ASG-31 Sight Panel Light Button - OFF'),				category = _('AN/ASG-31 Sight')},
{	down = intlights_commands.PnlLt_button,		cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_down = 1.0,		name = _('AN/ASG-31 Sight Panel Light Button - ON'),				category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.SightBit_EXT,			cockpit_device_id = devices.AN_ASG31,			value_down =  1.0,		name = _('AN/ASG-31 Sight BIT Switch - Up'),						category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.SightBit_EXT,			cockpit_device_id = devices.AN_ASG31,			value_down = -1.0,		name = _('AN/ASG-31 Sight BIT Switch - Down'),						category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.SightBit,				cockpit_device_id = devices.AN_ASG31,			value_down =  1.0,		name = _('AN/ASG-31 Sight BIT Switch - BIT 1'),						category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.SightBit,				cockpit_device_id = devices.AN_ASG31,			value_down =  0.0,		name = _('AN/ASG-31 Sight BIT Switch - OFF'),						category = _('AN/ASG-31 Sight')},
{	down = asg31_commands.SightBit,				cockpit_device_id = devices.AN_ASG31,			value_down = -1.0,		name = _('AN/ASG-31 Sight BIT Switch - BIT 2'),						category = _('AN/ASG-31 Sight')},
-- Sight Camera
{	down = camera_commands.SelectFPS_EXT,								cockpit_device_id = devices.SIGHT_CAMERA,	value_down = 1.0,				name = _('Sight Camera FPS Select Switch - 24/48'),					category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	down = camera_commands.SelectFPS,									cockpit_device_id = devices.SIGHT_CAMERA,	value_down = 0.0,				name = _('Sight Camera FPS Select Switch - 24'),					category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	down = camera_commands.SelectFPS,									cockpit_device_id = devices.SIGHT_CAMERA,	value_down = 1.0,				name = _('Sight Camera FPS Select Switch - 48'),					category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	pressed = camera_commands.Lens_fStop_EXT,							cockpit_device_id = devices.SIGHT_CAMERA,	value_pressed = -0.3,			name = _('Sight Camera Lens f-Stop Selector - CCW/Decrease'),		category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	pressed = camera_commands.Lens_fStop_EXT,							cockpit_device_id = devices.SIGHT_CAMERA,	value_pressed = 0.3,			name = _('Sight Camera Lens f-Stop Selector - CW/Increase'),		category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	down = camera_commands.Overrun_EXT,									cockpit_device_id = devices.SIGHT_CAMERA,	value_down = -1.0,				name = _('Sight Camera Overrun Selector - Right/Decrease'),			category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	down = camera_commands.Overrun_EXT,									cockpit_device_id = devices.SIGHT_CAMERA,	value_down = 1.0,				name = _('Sight Camera Overrun Selector - Left/Increase'),			category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	down = camera_commands.Overrun,										cockpit_device_id = devices.SIGHT_CAMERA,	value_down = 0.0,				name = _('Sight Camera Overrun Selector - 0'),						category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	down = camera_commands.Overrun,										cockpit_device_id = devices.SIGHT_CAMERA,	value_down = 0.1,				name = _('Sight Camera Overrun Selector - 3'),						category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	down = camera_commands.Overrun,										cockpit_device_id = devices.SIGHT_CAMERA,	value_down = 0.2,				name = _('Sight Camera Overrun Selector - 10'),						category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	down = camera_commands.Overrun,										cockpit_device_id = devices.SIGHT_CAMERA,	value_down = 0.3,				name = _('Sight Camera Overrun Selector - 20'),						category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},
{	down = camera_commands.CameraRun, up = camera_commands.CameraRun,	cockpit_device_id = devices.SIGHT_CAMERA,	value_down = 1, value_up = 0,	name = _('Sight Camera Run (Test) Switch'),							category = {_('AN/ASG-31 Sight'), _('Sight Camera')}},

---------------------------------------------
-- AN/APQ-159 Radar Control Panel -----------
---------------------------------------------
{	pressed = apq159_commands.ScaleKnob_EXT,	cockpit_device_id = devices.AN_APQ159,	value_pressed =  0.3,			name = _('AN/APQ-159 Radar Scale Knob - CW/Increase'),					category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.ScaleKnob_EXT,	cockpit_device_id = devices.AN_APQ159,	value_pressed = -0.3,			name = _('AN/APQ-159 Radar Scale Knob - CCW/Decrease'),					category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.BrightKnob_EXT,	cockpit_device_id = devices.AN_APQ159,	value_pressed =  0.3,			name = _('AN/APQ-159 Radar Bright Knob - CW/Increase'),					category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.BrightKnob_EXT,	cockpit_device_id = devices.AN_APQ159,	value_pressed = -0.3,			name = _('AN/APQ-159 Radar Bright Knob - CCW/Decrease'),				category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.PerKnob_EXT,		cockpit_device_id = devices.AN_APQ159,	value_pressed =  0.3,			name = _('AN/APQ-159 Radar Persistence Knob - CW/Increase'),			category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.PerKnob_EXT,		cockpit_device_id = devices.AN_APQ159,	value_pressed = -0.3,			name = _('AN/APQ-159 Radar Persistence Knob - CCW/Decrease'),			category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.VideoKnob_EXT,	cockpit_device_id = devices.AN_APQ159,	value_pressed =  0.3,			name = _('AN/APQ-159 Radar Video Knob - CW/Increase'),					category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.VideoKnob_EXT,	cockpit_device_id = devices.AN_APQ159,	value_pressed = -0.3,			name = _('AN/APQ-159 Radar Video Knob - CCW/Decrease'),					category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.CursorKnob_EXT,	cockpit_device_id = devices.AN_APQ159,	value_pressed =  0.3,			name = _('AN/APQ-159 Radar Cursor Knob - CW/Increase'),					category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.CursorKnob_EXT,	cockpit_device_id = devices.AN_APQ159,	value_pressed = -0.3,			name = _('AN/APQ-159 Radar Cursor Knob - CCW/Decrease'),				category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.PitchKnob_EXT,	cockpit_device_id = devices.AN_APQ159,	value_pressed =  0.3,			name = _('AN/APQ-159 Radar Pitch Knob - CW/Up'),						category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = apq159_commands.PitchKnob_EXT,	cockpit_device_id = devices.AN_APQ159,	value_pressed = -0.3,			name = _('AN/APQ-159 Radar Pitch Knob - CCW/Down'),						category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = iCommandPlaneRadarUp,														value_pressed =  1,				name = _('AN/APQ-159 Radar Elevation Antenna Tilt Control - CW/Up'),	category = _('AN/APQ-159 Radar Control Panel')},
{	pressed = iCommandPlaneRadarDown,													value_pressed = -1,				name = _('AN/APQ-159 Radar Elevation Antenna Tilt Control - CCW/Down'),	category = _('AN/APQ-159 Radar Control Panel')},
{	down = iCommandSelecterUp,		up = iCommandSelecterUp,							value_down =  1, value_up = 0,	name = _('AN/APQ-159 Radar TDC Button - Up'),							category = _('AN/APQ-159 Radar Control Panel')},
{	down = iCommandSelecterDown,	up = iCommandSelecterDown,							value_down = -1, value_up = 0,	name = _('AN/APQ-159 Radar TDC Button - Down'),							category = _('AN/APQ-159 Radar Control Panel')},
{	down = iCommandSelecterLeft,	up = iCommandSelecterLeft,							value_down = -1, value_up = 0,	name = _('AN/APQ-159 Radar TDC Button - Left'),							category = _('AN/APQ-159 Radar Control Panel')},
{	down = iCommandSelecterRight,	up = iCommandSelecterRight,							value_down =  1, value_up = 0,	name = _('AN/APQ-159 Radar TDC Button - Right'),						category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.RangeSelector_EXT,	cockpit_device_id = devices.AN_APQ159,	value_down =  1.0,				name = _('AN/APQ-159 Radar Range Selector - CW/Increase'),				category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.RangeSelector_EXT,	cockpit_device_id = devices.AN_APQ159,	value_down = -1.0,				name = _('AN/APQ-159 Radar Range Selector - CCW/Decrease'),				category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.RangeSelector,		cockpit_device_id = devices.AN_APQ159,	value_down =  0.0,				name = _('AN/APQ-159 Radar Range Selector - 5'),						category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.RangeSelector,		cockpit_device_id = devices.AN_APQ159,	value_down =  0.1,				name = _('AN/APQ-159 Radar Range Selector - 10'),						category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.RangeSelector,		cockpit_device_id = devices.AN_APQ159,	value_down =  0.2,				name = _('AN/APQ-159 Radar Range Selector - 20'),						category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.RangeSelector,		cockpit_device_id = devices.AN_APQ159,	value_down =  0.3,				name = _('AN/APQ-159 Radar Range Selector - 40'),						category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.ModeSelector_EXT,	cockpit_device_id = devices.AN_APQ159,	value_down =  1.0,				name = _('AN/APQ-159 Radar Mode Selector - CW'),						category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.ModeSelector_EXT,	cockpit_device_id = devices.AN_APQ159,	value_down = -1.0,				name = _('AN/APQ-159 Radar Mode Selector - CCW'),						category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.ModeSelector,		cockpit_device_id = devices.AN_APQ159,	value_down =  0.0,				name = _('AN/APQ-159 Radar Mode Selector - OFF'),						category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.ModeSelector,		cockpit_device_id = devices.AN_APQ159,	value_down =  0.1,				name = _('AN/APQ-159 Radar Mode Selector - STBY'),						category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.ModeSelector,		cockpit_device_id = devices.AN_APQ159,	value_down =  0.2,				name = _('AN/APQ-159 Radar Mode Selector - OPER'),						category = _('AN/APQ-159 Radar Control Panel')},
{	down = apq159_commands.ModeSelector,		cockpit_device_id = devices.AN_APQ159,	value_down =  0.3,				name = _('AN/APQ-159 Radar Mode Selector - TEST'),						category = _('AN/APQ-159 Radar Control Panel')},
{combos = {{key = "JOY_BTN15"}},		down = iCommandPlane_LockOn_start,	up = iCommandPlane_LockOn_finish,												name = _('AN/APQ-159 Radar ACQ Button'),								category = _('AN/APQ-159 Radar Control Panel')},



---------------------------------------------
-- Instrument Panel -------------------------
---------------------------------------------
-- Landing Gear
{	down = iCommandPlaneGear,																																name = _('Landing Gear Lever - LG UP/LG DOWN'),					category = _('Instrument Panel')},
{	down = iCommandPlaneGearUp,																																name = _('Landing Gear Lever - LG UP'),							category = _('Instrument Panel')},
{	down = iCommandPlaneGearDown,																															name = _('Landing Gear Lever - LG DOWN'),						category = _('Instrument Panel')},
{	down = gear_commands.DownOverride,		up = gear_commands.DownOverride,	cockpit_device_id = devices.GEAR_INTERFACE,	value_down = 1, value_up = 0,	name = _('Landing Gear Downlock Override Button'),				category = _('Instrument Panel')},
{	down = gear_commands.WarningSilence,	up = gear_commands.WarningSilence,	cockpit_device_id = devices.GEAR_INTERFACE,	value_down = 1, value_up = 0,	name = _('Landing Gear and Flap Warning Silence Button'),		category = _('Instrument Panel')},
{	down = gear_commands.LeftLGLampTest,	up = gear_commands.LeftLGLampTest,	cockpit_device_id = devices.GEAR_INTERFACE,	value_down = 1, value_up = 0,	name = _('Left Landing Gear Lamp - TEST'),						category = _('Instrument Panel')},
{	down = gear_commands.NoseLGLampTest,	up = gear_commands.NoseLGLampTest,	cockpit_device_id = devices.GEAR_INTERFACE,	value_down = 1, value_up = 0,	name = _('Nose Landing Gear Lamp - TEST'),						category = _('Instrument Panel')},
{	down = gear_commands.RightLGLampTest,	up = gear_commands.RightLGLampTest,	cockpit_device_id = devices.GEAR_INTERFACE,	value_down = 1, value_up = 0,	name = _('Right Landing Gear Lamp - TEST'),						category = _('Instrument Panel')},
{	pressed = gear_commands.LeftLGLampDim_EXT,									cockpit_device_id = devices.GEAR_INTERFACE,	value_pressed = -0.2,			name = _('Left Landing Gear Lamp Brightness - CCW/Decrease'),	category = _('Instrument Panel')},
{	pressed = gear_commands.LeftLGLampDim_EXT,									cockpit_device_id = devices.GEAR_INTERFACE,	value_pressed = 0.2,			name = _('Left Landing Gear Lamp Brightness - CW/Increase'),	category = _('Instrument Panel')},
{	pressed = gear_commands.NoseLGLampDim_EXT,									cockpit_device_id = devices.GEAR_INTERFACE,	value_pressed = -0.2,			name = _('Nose Landing Gear Lamp Brightness - CCW/Decrease'),	category = _('Instrument Panel')},
{	pressed = gear_commands.NoseLGLampDim_EXT,									cockpit_device_id = devices.GEAR_INTERFACE,	value_pressed = 0.2,			name = _('Nose Landing Gear Lamp Brightness - CW/Increase'),	category = _('Instrument Panel')},
{	pressed = gear_commands.RightLGLampDim_EXT,									cockpit_device_id = devices.GEAR_INTERFACE,	value_pressed = -0.2,			name = _('Right Landing Gear Lamp Brightness - CCW/Decrease'),	category = _('Instrument Panel')},
{	pressed = gear_commands.RightLGLampDim_EXT,									cockpit_device_id = devices.GEAR_INTERFACE,	value_pressed = 0.2,			name = _('Right Landing Gear Lamp Brightness - CW/Increase'),	category = _('Instrument Panel')},
-- Deselerating devices
{	down = gear_commands.Hook,		up = gear_commands.Hook,	cockpit_device_id = devices.GEAR_INTERFACE,	value_down = 1, value_up = 0,	name = _('Arresting Hook Button'),				category = _('Instrument Panel')},
{combos = {{key = "JOY_BTN26"}},		down = iCommandPlaneParachute,	up = iCommandPlaneParachute,											value_down = 1, value_up = 0,	name = _('Drag Chute T-Handle - PULL/PUSH'),	category = _('Instrument Panel')},
-- Airspeed/Mach Indicator
{	pressed = device_commands.Button_1,	cockpit_device_id = devices.IAS_MACH_INDICATOR,	value_pressed = -0.05,	name = _('Airspeed/Mach Indicator Index Setting Pointer Knob - CCW/Decrease'),	category = _('Instrument Panel')},
{	pressed = device_commands.Button_1,	cockpit_device_id = devices.IAS_MACH_INDICATOR,	value_pressed = 0.05,	name = _('Airspeed/Mach Indicator Index Setting Pointer Knob - CW/Increase'),	category = _('Instrument Panel')},
-- Attitude Indicator
{	pressed = iCommandADI_ZeroPitchTrimLeft,	name = _('AI Pitch Trim Knob - CCW/Decrease'),	category = _('Instrument Panel')},
{	pressed = iCommandADI_ZeroPitchTrimRight,	name = _('AI Pitch Trim Knob - CW/Increase'),	category = _('Instrument Panel')},
{	down = ahrs_commands.AHRS_CMD_FAST_ERECT,	up = ahrs_commands.AHRS_CMD_FAST_ERECT,	cockpit_device_id = devices.AHRS,	value_down = 1.0,	value_up = 0.0,	name = _('FAST ERECT Button'),		category = _('Instrument Panel')},
-- Altimeter
{	pressed = iCommandAltimeterPressureDecrease,																												name = _('Altimeter Zero Setting Knob - CCW/Decrease'),		category = _('Instrument Panel')},
{	pressed = iCommandAltimeterPressureIncrease,																												name = _('Altimeter Zero Setting Knob - CW/Increase'),		category = _('Instrument Panel')},
{	down = aau34_commands.AAU34_ClkCmd_ELECT,	up = aau34_commands.AAU34_ClkCmd_ELECT,	cockpit_device_id = devices.AAU34,	value_down = -1.0,	value_up = 0.0,	name = _('Altimeter Mode Control Lever - ELECT(rical)'),	category = _('Instrument Panel')},
{	down = aau34_commands.AAU34_ClkCmd_PNEU,	up = aau34_commands.AAU34_ClkCmd_PNEU,	cockpit_device_id = devices.AAU34,	value_down = 1.0,	value_up = 0.0,	name = _('Altimeter Mode Control Lever - PNEU(matic)'),		category = _('Instrument Panel')},
-- HSI
{	pressed = iCommandHSI_HeadingRotaryLeft,	name = _('HSI Heading Set Knob - CCW/Decrease'),	category = _('Instrument Panel')},
{	pressed = iCommandHSI_HeadingRotaryRight,	name = _('HSI Heading Set Knob - CW/Increase'),		category = _('Instrument Panel')},
{	pressed = iCommandHSI_CourseRotaryLeft,		name = _('HSI Course Set Knob - CCW/Decrease'),		category = _('Instrument Panel')},
{	pressed = iCommandHSI_CourseRotaryRight,	name = _('HSI Course Set Knob - CW/Increase'),		category = _('Instrument Panel')},
-- Standby Attitude Indicator
{	pressed = iCommand_AGR_axis_left,																											name = _('SAI Cage/Pitch Trim Knob - CCW/Decrease'),	category = _('Instrument Panel')},
{	pressed = iCommand_AGR_axis_right,																											name = _('SAI Cage/Pitch Trim Knob - CW/Increase'),		category = _('Instrument Panel')},
{	down = sai_commands.CMD_SAI_CAGE, up = sai_commands.CMD_SAI_CAGE,	cockpit_device_id = devices.SAI,	value_down = 1.0, value_up = 0.0,	name = _('SAI Cage/Pitch Trim Knob - PULL'),			category = _('Instrument Panel')},
-- Accelerometer
{	down = device_commands.Button_1, up = device_commands.Button_1,	cockpit_device_id = devices.ACCELEROMETER,	value_down = 1.0, value_up = 0.0,	name = _('Accelerometer Reset Button'),	category = _('Instrument Panel')},
-- RWR Indicator Control
{	down = ic_commands.Mode,		up = ic_commands.Mode,			cockpit_device_id = devices.RWR_IC,	value_down = 1.0, value_up = 0.0,	name = _('RWR Indicator Control MODE Button'),					category = {_('Instrument Panel'), _('RWR')}},
{	down = ic_commands.Search,		up = ic_commands.Search,		cockpit_device_id = devices.RWR_IC,	value_down = 1.0, value_up = 0.0,	name = _('RWR Indicator Control SEARCH Button'),				category = {_('Instrument Panel'), _('RWR')}},
{	down = ic_commands.Handoff,		up = ic_commands.Handoff,		cockpit_device_id = devices.RWR_IC,	value_down = 1.0, value_up = 0.0,	name = _('RWR Indicator Control HANDOFF Button'),				category = {_('Instrument Panel'), _('RWR')}},
{	down = ic_commands.Launch,		up = ic_commands.Launch,		cockpit_device_id = devices.RWR_IC,	value_down = 1.0, value_up = 0.0,	name = _('RWR Indicator Control LAUNCH Button'),				category = {_('Instrument Panel'), _('RWR')}},
{	down = ic_commands.Altitude,	up = ic_commands.Altitude,		cockpit_device_id = devices.RWR_IC,	value_down = 1.0, value_up = 0.0,	name = _('RWR Indicator Control ALTITUDE Button'),				category = {_('Instrument Panel'), _('RWR')}},
{	down = ic_commands.Btn_T,		up = ic_commands.Btn_T,			cockpit_device_id = devices.RWR_IC,	value_down = 1.0, value_up = 0.0,	name = _('RWR Indicator Control T Button'),						category = {_('Instrument Panel'), _('RWR')}},
{	down = ic_commands.SysTest,		up = ic_commands.SysTest,		cockpit_device_id = devices.RWR_IC,	value_down = 1.0, value_up = 0.0,	name = _('RWR Indicator Control SYS TEST Button'),				category = {_('Instrument Panel'), _('RWR')}},
{	down = ic_commands.UnknownShip,	up = ic_commands.UnknownShip,	cockpit_device_id = devices.RWR_IC,	value_down = 1.0, value_up = 0.0,	name = _('RWR Indicator Control UNKNOWN SHIP Button'),			category = {_('Instrument Panel'), _('RWR')}},
{	down = ic_commands.ActPwr,		up = ic_commands.ActPwr,		cockpit_device_id = devices.RWR_IC,	value_down = 1.0, value_up = 0.0,	name = _('RWR Indicator Control ACT/PWR Button'),				category = {_('Instrument Panel'), _('RWR')}},
{	down = ic_commands.Power,		up = ic_commands.Power,			cockpit_device_id = devices.RWR_IC,	value_down = 1.0, value_up = 0.0,	name = _('RWR Indicator Control POWER Button'),					category = {_('Instrument Panel'), _('RWR')}},
{	pressed = ic_commands.Volume_EXT,								cockpit_device_id = devices.RWR_IC,	value_pressed = -1.0,				name = _('RWR Indicator Control AUDIO Knob - CCW/Decrease'),	category = {_('Instrument Panel'), _('RWR')}},
{	pressed = ic_commands.Volume_EXT,								cockpit_device_id = devices.RWR_IC,	value_pressed = 1.0,				name = _('RWR Indicator Control AUDIO Knob - CW/Increase'),		category = {_('Instrument Panel'), _('RWR')}},
{	pressed = ic_commands.Brightness_EXT,							cockpit_device_id = devices.RWR_IC,	value_pressed = -1.0,				name = _('RWR Indicator Control DIM Knob - CCW/Decrease'),		category = {_('Instrument Panel'), _('RWR')}},
{	pressed = ic_commands.Brightness_EXT,							cockpit_device_id = devices.RWR_IC,	value_pressed = 1.0,				name = _('RWR Indicator Control DIM Knob - CW/Increase'),		category = {_('Instrument Panel'), _('RWR')}},
-- RWR Indicator
{	pressed = alr87_commands.Brightness_EXT,						cockpit_device_id = devices.AN_ALR87,	value_pressed = -1.0,			name = _('RWR Indicator INT Knob - CCW/Decrease'),				category = {_('Instrument Panel'), _('RWR')}},
{	pressed = alr87_commands.Brightness_EXT,						cockpit_device_id = devices.AN_ALR87,	value_pressed = 1.0,			name = _('RWR Indicator INT Knob - CW/Increase'),				category = {_('Instrument Panel'), _('RWR')}},
-- Clock
{	down = clock_commands.CLOCK_right_lev_down,		up = clock_commands.CLOCK_right_lev_down,	cockpit_device_id = devices.CLOCK,	value_down = 1.0, value_up = 0.0,	name = _('Clock Elapsed Time Knob - PUSH/RELEASE'),				category = {_('Instrument Panel')}},
{	down = clock_commands.CLOCK_left_lev_up,		up = clock_commands.CLOCK_left_lev_up,		cockpit_device_id = devices.CLOCK,	value_down = 1.0, value_up = 0.0,	name = _('Clock Winding and Setting Knob - PULL/RELEASE'),		category = {_('Instrument Panel')}},
{	pressed = clock_commands.CLOCK_left_lev_rotate,												cockpit_device_id = devices.CLOCK,	value_pressed = -0.05,				name = _('Clock Winding and Setting Knob - CCW'),				category = {_('Instrument Panel')}},
{	pressed = clock_commands.CLOCK_left_lev_rotate,												cockpit_device_id = devices.CLOCK,	value_pressed = 0.05,				name = _('Clock Winding and Setting Knob - CW'),				category = {_('Instrument Panel')}},
--
{	down = intlights_commands.MasterReset, up = intlights_commands.MasterReset,	cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_down = 1.0, value_up = 0.0,	name = _('Master Caution Button'), category = _('Instrument Panel')},

---------------------------------------------
-- Left Panels ------------------------------
---------------------------------------------
{	down = gear_commands.NoseStrut_EXT,		cockpit_device_id = devices.GEAR_INTERFACE,	value_down = 1.0,	name = _('Nose Strut Switch - EXTEND/RETRACT'),		category = {_('Left Panels')}},
{	down = gear_commands.NoseStrut,			cockpit_device_id = devices.GEAR_INTERFACE,	value_down = 1.0,	name = _('Nose Strut Switch - EXTEND'),				category = {_('Left Panels')}},
{	down = gear_commands.NoseStrut,			cockpit_device_id = devices.GEAR_INTERFACE,	value_down = 0.0,	name = _('Nose Strut Switch - RETRACT'),			category = {_('Left Panels')}},
-- Countermeasures Dispenser Control Panel
{	down = cmds_commands.FlareJettison_Cover_EXT,									cockpit_device_id = devices.CMDS,	value_down = 1.0,					name = _('Flare Jettison Switch Cover - OPEN/CLOSE'),	category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareJettison_Cover,										cockpit_device_id = devices.CMDS,	value_down = 1.0,					name = _('Flare Jettison Switch Cover - OPEN'),			category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareJettison_Cover,										cockpit_device_id = devices.CMDS,	value_down = 0.0,					name = _('Flare Jettison Switch Cover - CLOSE'),		category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareJettison_EXT,											cockpit_device_id = devices.CMDS,	value_down = 1.0,					name = _('Flare Jettison Switch - UP/OFF'),				category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareJettison,												cockpit_device_id = devices.CMDS,	value_down = 1.0,					name = _('Flare Jettison Switch - UP'),					category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareJettison,												cockpit_device_id = devices.CMDS,	value_down = 0.0,					name = _('Flare Jettison Switch - OFF'),				category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.ChaffMode_EXT,												cockpit_device_id = devices.CMDS,	value_down = -1.0,					name = _('Chaff Mode Selector - CCW/Left'),				category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.ChaffMode_EXT,												cockpit_device_id = devices.CMDS,	value_down = 1.0,					name = _('Chaff Mode Selector - CW/Right'),				category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.ChaffMode,													cockpit_device_id = devices.CMDS,	value_down = 0.0,					name = _('Chaff Mode Selector - OFF'),					category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.ChaffMode,													cockpit_device_id = devices.CMDS,	value_down = 0.1,					name = _('Chaff Mode Selector - SINGLE'),				category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.ChaffMode,													cockpit_device_id = devices.CMDS,	value_down = 0.2,					name = _('Chaff Mode Selector - PRGM'),					category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.ChaffMode,													cockpit_device_id = devices.CMDS,	value_down = 0.3,					name = _('Chaff Mode Selector - MULT'),					category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareMode_EXT,												cockpit_device_id = devices.CMDS,	value_down = -1.0,					name = _('Flare Mode Selector - CCW/Left'),				category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareMode_EXT,												cockpit_device_id = devices.CMDS,	value_down = 1.0,					name = _('Flare Mode Selector - CW/Right'),				category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareMode,													cockpit_device_id = devices.CMDS,	value_down = 0.0,					name = _('Flare Mode Selector - OFF'),					category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareMode,													cockpit_device_id = devices.CMDS,	value_down = 0.1,					name = _('Flare Mode Selector - SINGLE'),				category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareMode,													cockpit_device_id = devices.CMDS,	value_down = 0.2,					name = _('Flare Mode Selector - PRGM'),					category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.ChaffCounterReset,	up = cmds_commands.ChaffCounterReset,	cockpit_device_id = devices.CMDS,	value_down = 1.0,	value_up = 0.0,	name = _('Chaff Counter Reset Button'),					category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
{	down = cmds_commands.FlareCounterReset,	up = cmds_commands.FlareCounterReset,	cockpit_device_id = devices.CMDS,	value_down = 1.0,	value_up = 0.0,	name = _('Flare Counter Reset Button'),					category = {_('Left Panels'), _('Countermeasures Dispenser Control Panel')}},
-- Control System
{	down = control_commands.YawDamper_EXT,		cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0,		name = _('Yaw Damper Switch - YAW/OFF'),		category = {_('Left Panels')}},
{	down = control_commands.YawDamper,			cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0,		name = _('Yaw Damper Switch - YAW'),			category = {_('Left Panels')}},
{	down = control_commands.YawDamper,			cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 0.0,		name = _('Yaw Damper Switch - OFF'),			category = {_('Left Panels')}},
{combos = {{key = "JOY_BTN25"}},		down = control_commands.YawDamper,		up = control_commands.YawDamper,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0,	value_up = 0.0,	name = _('Yaw Damper Switch (HOTAS)- YAW/OFF'),		category = {_('Left Panels'),_('HOTAS')}},
{	down = control_commands.PitchDamper_EXT,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0,		name = _('Pitch Damper Switch - PITCH/OFF'),	category = {_('Left Panels')}},
{	down = control_commands.PitchDamper,		cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0,		name = _('Pitch Damper Switch - PITCH'),		category = {_('Left Panels')}},
{	down = control_commands.PitchDamper,		cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 0.0,		name = _('Pitch Damper Switch - OFF'),			category = {_('Left Panels')}},
{combos = {{key = "JOY_BTN24"}},		down = control_commands.PitchDamper,	up = control_commands.PitchDamper,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0,	value_up = 0.0,	name = _('Pitch Damper Switch (HOTAS)- PITCH/OFF'),	category = {_('Left Panels'),_('HOTAS')}},
{	pressed = control_commands.RudderTrim_EXT,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_pressed = -1.0,	name = _('Rudder Trim Knob - CCW/Left'),		category = {_('Left Panels')}},
{	pressed = control_commands.RudderTrim_EXT,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_pressed = 1.0,	name = _('Rudder Trim Knob - CW/Right'),		category = {_('Left Panels')}},
--
{	pressed = ecs_commands.CockpitAirInletL1Hor_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed = -0.2,	name = _('Cockpit Left Air Inlet 1 - Left'),		category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL1Hor_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed =  0.2,	name = _('Cockpit Left Air Inlet 1 - Right'),		category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL1Ver_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed = -0.2,	name = _('Cockpit Left Air Inlet 1 - Down'),		category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL1Ver_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed =  0.2,	name = _('Cockpit Left Air Inlet 1 - Up'),			category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL1Valve_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed = -0.3,	name = _('Cockpit Left Air Inlet 1 Valve - Left'),	category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL1Valve_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed =  0.3,	name = _('Cockpit Left Air Inlet 1 Valve - Right'),	category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL2Hor_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed = -0.2,	name = _('Cockpit Left Air Inlet 2 - Left'),		category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL2Hor_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed =  0.2,	name = _('Cockpit Left Air Inlet 2 - Right'),		category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL2Ver_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed = -0.2,	name = _('Cockpit Left Air Inlet 2 - Down'),		category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL2Ver_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed =  0.2,	name = _('Cockpit Left Air Inlet 2 - Up'),			category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL2Valve_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed = -0.3,	name = _('Cockpit Left Air Inlet 2 Valve - Left'),	category = {_('Left Panels')}},
{	pressed = ecs_commands.CockpitAirInletL2Valve_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed =  0.3,	name = _('Cockpit Left Air Inlet 2 Valve - Right'),	category = {_('Left Panels')}},
--
-- TODO: Anti-G

---------------------------------------------
-- Left Vertical Panel ----------------------
---------------------------------------------
-- Ext Lights
{	down = extlights_commands.LdgTaxi_EXT,	cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	value_down = 1.0,	name = _('Landing & Taxi Light Switch - ON/OFF'),	category = {_('Left Vertical Panel')}},
{	down = extlights_commands.LdgTaxi,		cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	value_down = 1.0,	name = _('Landing & Taxi Light Switch - ON'),		category = {_('Left Vertical Panel')}},
{	down = extlights_commands.LdgTaxi,		cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	value_down = 0.0,	name = _('Landing & Taxi Light Switch - OFF'),		category = {_('Left Vertical Panel')}},
-- Engine
{combos = {{key = "JOY_BTN31"}},		down = engine_commands.EngineStartLeft,		up = engine_commands.EngineStartLeft,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 1.0, value_up = 0.0,	name = _('Left Engine Start Button'),		category = _('Left Vertical Panel')},
{combos = {{key = "JOY_BTN32"}},		down = engine_commands.EngineStartRight,	up = engine_commands.EngineStartRight,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 1.0, value_up = 0.0,	name = _('Right Engine Start Button'),		category = _('Left Vertical Panel')},
-- Fuel
{	down = fuel_commands.FuelShutoffCover_Left_EXT,		cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,	name = _('Left Fuel Shutoff Switch Cover - OPEN/CLOSE'),	category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoffCover_Left,			cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,	name = _('Left Fuel Shutoff Switch Cover - OPEN'),			category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoffCover_Left,			cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 0.0,	name = _('Left Fuel Shutoff Switch Cover - CLOSE'),			category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoff_Left_EXT,			cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,	name = _('Left Fuel Shutoff Switch - LEFT/CLOSED'),			category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoff_Left,				cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 0.0,	name = _('Left Fuel Shutoff Switch - LEFT'),				category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoff_Left,				cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,	name = _('Left Fuel Shutoff Switch - CLOSED'),				category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoffCover_Right_EXT,	cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,	name = _('Right Fuel Shutoff Switch Cover - OPEN/CLOSE'),	category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoffCover_Right,		cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,	name = _('Right Fuel Shutoff Switch Cover - OPEN'),			category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoffCover_Right,		cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 0.0,	name = _('Right Fuel Shutoff Switch Cover - CLOSE'),		category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoff_Right_EXT,			cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,	name = _('Right Fuel Shutoff Switch - RIGHT/CLOSED'),		category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoff_Right,				cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 0.0,	name = _('Right Fuel Shutoff Switch - RIGHT'),				category = {_('Left Vertical Panel')}},
{	down = fuel_commands.FuelShutoff_Right,				cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,	name = _('Right Fuel Shutoff Switch - CLOSED'),				category = {_('Left Vertical Panel')}},
-- Int Lights
{	pressed = intlights_commands.ArmtPanel_knob_EXT,	cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_pressed = -1.0,	name = _('Armament Panel Lights Knob - CCW/Decrease'),		category = {_('Left Vertical Panel')}},
{	pressed = intlights_commands.ArmtPanel_knob_EXT,	cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_pressed = 1.0,	name = _('Armament Panel Lights Knob - CW/Increase'),		category = {_('Left Vertical Panel')}},
-- Armament
{	pressed = weapons_commands.MissileVolume_EXT,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_pressed = -1.0,	name = _('Missile Volume Knob - CCW/Decrease'),								category = {_('Left Vertical Panel')}},
{	pressed = weapons_commands.MissileVolume_EXT,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_pressed = 1.0,	name = _('Missile Volume Knob - CW/Increase'),								category = {_('Left Vertical Panel')}},
{	down = weapons_commands.Interval_EXT,				cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Interval Switch [sec] - Up'),										category = {_('Left Vertical Panel')}},
{	down = weapons_commands.Interval_EXT,				cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = -1.0,		name = _('Interval Switch [sec] - Down'),									category = {_('Left Vertical Panel')}},
{	down = weapons_commands.Interval,					cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Interval Switch [sec] - .06'),									category = {_('Left Vertical Panel')}},
{	down = weapons_commands.Interval,					cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('Interval Switch [sec] - .10'),									category = {_('Left Vertical Panel')}},
{	down = weapons_commands.Interval,					cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = -1.0,		name = _('Interval Switch [sec] - .14'),									category = {_('Left Vertical Panel')}},
{	down = weapons_commands.WingtipLeft_Select_EXT,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (LEFT WINGTIP) - ON/OFF'),		category = {_('Left Vertical Panel')}},
{	down = weapons_commands.WingtipLeft_Select,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (LEFT WINGTIP) - ON'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.WingtipLeft_Select,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('Armament Position Selector Switch (LEFT WINGTIP) - OFF'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.OutbdLeft_Select_EXT,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (LEFT OUTBD) - ON/OFF'),		category = {_('Left Vertical Panel')}},
{	down = weapons_commands.OutbdLeft_Select,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (LEFT OUTBD) - ON'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.OutbdLeft_Select,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('Armament Position Selector Switch (LEFT OUTBD) - OFF'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.InbdLeft_Select_EXT,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (LEFT INBD) - ON/OFF'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.InbdLeft_Select,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (LEFT INBD) - ON'),				category = {_('Left Vertical Panel')}},
{	down = weapons_commands.InbdLeft_Select,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('Armament Position Selector Switch (LEFT INBD) - OFF'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.Center_Select_EXT,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (CENTERLINE) - ON/OFF'),		category = {_('Left Vertical Panel')}},
{	down = weapons_commands.Center_Select,				cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (CENTERLINE) - ON'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.Center_Select,				cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('Armament Position Selector Switch (CENTERLINE) - OFF'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.InbdRight_Select_EXT,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (RIGHT INBD) - ON/OFF'),		category = {_('Left Vertical Panel')}},
{	down = weapons_commands.InbdRight_Select,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (RIGHT INBD) - ON'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.InbdRight_Select,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('Armament Position Selector Switch (RIGHT INBD) - OFF'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.OutbdRight_Select_EXT,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (RIGHT OUTBD) - ON/OFF'),		category = {_('Left Vertical Panel')}},
{	down = weapons_commands.OutbdRight_Select,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (RIGHT OUTBD) - ON'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.OutbdRight_Select,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('Armament Position Selector Switch (RIGHT OUTBD) - OFF'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.WingtipRight_Select_EXT,	cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (RIGHT WINGTIP) - ON/OFF'),		category = {_('Left Vertical Panel')}},
{	down = weapons_commands.WingtipRight_Select,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Armament Position Selector Switch (RIGHT WINGTIP) - ON'),			category = {_('Left Vertical Panel')}},
{	down = weapons_commands.WingtipRight_Select,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('Armament Position Selector Switch (RIGHT WINGTIP) - OFF'),		category = {_('Left Vertical Panel')}},
{	down = weapons_commands.BombsArm_EXT,				cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Bombs Arm Switch - CW'),											category = {_('Left Vertical Panel')}},
{	down = weapons_commands.BombsArm_EXT,				cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = -1.0,		name = _('Bombs Arm Switch - CCW'),											category = {_('Left Vertical Panel')}},
{	down = weapons_commands.BombsArm,					cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.2,		name = _('Bombs Arm Switch - SAFE'),										category = {_('Left Vertical Panel')}},
{	down = weapons_commands.BombsArm,					cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.4,		name = _('Bombs Arm Switch - NOSE'),										category = {_('Left Vertical Panel')}},
{	down = weapons_commands.BombsArm,					cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.6,		name = _('Bombs Arm Switch - NOSE & TAIL'),									category = {_('Left Vertical Panel')}},
{	down = weapons_commands.BombsArm,					cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.8,		name = _('Bombs Arm Switch - TAIL'),										category = {_('Left Vertical Panel')}},
{	down = weapons_commands.GunsMslCamrCover_EXT,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Guns, Missile and Camera Switch Cover - OPEN/CLOSE'),				category = {_('Left Vertical Panel')}},
{	down = weapons_commands.GunsMslCamrCover,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Guns, Missile and Camera Switch Cover - OPEN'),					category = {_('Left Vertical Panel')}},
{	down = weapons_commands.GunsMslCamrCover,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('Guns, Missile and Camera Switch Cover - CLOSE'),					category = {_('Left Vertical Panel')}},
{	down = weapons_commands.GunsMslCamr_EXT,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Guns, Missile and Camera Switch - Up'),							category = {_('Left Vertical Panel')}},
{	down = weapons_commands.GunsMslCamr_EXT,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = -1.0,		name = _('Guns, Missile and Camera Switch - Down'),							category = {_('Left Vertical Panel')}},
{	down = weapons_commands.GunsMslCamr,				cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('Guns, Missile and Camera Switch - GUNS MSL & CAMR'),				category = {_('Left Vertical Panel')}},
{	down = weapons_commands.GunsMslCamr,				cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('Guns, Missile and Camera Switch - OFF'),							category = {_('Left Vertical Panel')}},
{	down = weapons_commands.GunsMslCamr,				cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = -1.0,		name = _('Guns, Missile and Camera Switch - CAMR ONLY'),					category = {_('Left Vertical Panel')}},
{combos = {{key = "JOY_BTN27"}},		down = weapons_commands.GunsMslCamr,	up = weapons_commands.GunsMslCamr,	cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,	value_up = 0.0,	name = _('Guns, Missile and Camera Switch - GUNS MSL & CAMR/OFF'),				category = {_('Left Vertical Panel'),_('HOTAS')}},
{combos = {{key = "JOY_BTN28"}},		down = weapons_commands.GunsMslCamr,	up = weapons_commands.GunsMslCamr,	cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = -1.0,	value_up = 0.0,	name = _('Guns, Missile and Camera Switch - CAMR ONLY/OFF'),					category = {_('Left Vertical Panel'),_('HOTAS')}},
{	down = weapons_commands.ExtStoresSelect_EXT,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1.0,		name = _('External Stores Selector - CW'),									category = {_('Left Vertical Panel')}},
{	down = weapons_commands.ExtStoresSelect_EXT,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = -1.0,		name = _('External Stores Selector - CCW'),									category = {_('Left Vertical Panel')}},
{	down = weapons_commands.ExtStoresSelect,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.0,		name = _('External Stores Selector - RIPL'),								category = {_('Left Vertical Panel')}},
{	down = weapons_commands.ExtStoresSelect,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.1,		name = _('External Stores Selector - BOMB'),								category = {_('Left Vertical Panel')}},
{	down = weapons_commands.ExtStoresSelect,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.2,		name = _('External Stores Selector - SAFE'),								category = {_('Left Vertical Panel')}},
{	down = weapons_commands.ExtStoresSelect,			cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 0.3,		name = _('External Stores Selector - RKT/DISP'),							category = {_('Left Vertical Panel')}},
-- Jettison System
{	down = jettison_commands.EmerAllJettCap,											cockpit_device_id = devices.JETTISON_SYSTEM,	value_down = 1.0,					name = _('Emergency All Jettison Button Cover - OPEN'),		category = {_('Left Vertical Panel')}},
{	down = jettison_commands.EmerAllJett,		up = jettison_commands.EmerAllJett,		cockpit_device_id = devices.JETTISON_SYSTEM,	value_down = 1.0,	value_up = 0.0,	name = _('Emergency All Jettison Button'),					category = {_('Left Vertical Panel')}},
{	down = jettison_commands.SelectJettBtn,		up = jettison_commands.SelectJettBtn,	cockpit_device_id = devices.JETTISON_SYSTEM,	value_down = 1.0,	value_up = 0.0,	name = _('Select Jettison Button'),							category = {_('Left Vertical Panel')}},
{	down = jettison_commands.SelectJettSw_EXT,											cockpit_device_id = devices.JETTISON_SYSTEM,	value_down = 1.0,					name = _('Select Jettison Switch - Up'),					category = {_('Left Vertical Panel')}},
{	down = jettison_commands.SelectJettSw_EXT,											cockpit_device_id = devices.JETTISON_SYSTEM,	value_down = -1.0,					name = _('Select Jettison Switch - Down'),					category = {_('Left Vertical Panel')}},
{	down = jettison_commands.SelectJettSw,												cockpit_device_id = devices.JETTISON_SYSTEM,	value_down = 1.0,					name = _('Select Jettison Switch - SELECT POSITION'),		category = {_('Left Vertical Panel')}},
{	down = jettison_commands.SelectJettSw,												cockpit_device_id = devices.JETTISON_SYSTEM,	value_down = 0.0,					name = _('Select Jettison Switch - OFF'),					category = {_('Left Vertical Panel')}},
{	down = jettison_commands.SelectJettSw,												cockpit_device_id = devices.JETTISON_SYSTEM,	value_down = -1.0,					name = _('Select Jettison Switch - ALL PYLONS'),			category = {_('Left Vertical Panel')}},
--
{	down = gear_commands.AltRelease,	up = gear_commands.AltRelease,	cockpit_device_id = devices.GEAR_INTERFACE,	value_down = 1.0, value_up = 0.0,	name = _('Landing Gear Alternate Release Handle'),	category = {_('Left Vertical Panel')}},

---------------------------------------------
-- Right Vertical Panel ---------------------
---------------------------------------------
-- Electrical Panel
{	down = electric_commands.BatterySw_EXT,															cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,					name = _('Battery Switch - BATT/OFF'),			category = {_('Right Vertical Panel')}},
{	down = electric_commands.BatterySw,																cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,					name = _('Battery Switch - BATT'),				category = {_('Right Vertical Panel')}},
{	down = electric_commands.BatterySw,																cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,					name = _('Battery Switch - OFF'),				category = {_('Right Vertical Panel')}},
{	down = electric_commands.LeftGeneratorSw_EXT,	up = electric_commands.LeftGeneratorSw_EXT,		cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		value_up = 0,	name = _('Left Generator Switch - Up'),			category = {_('Right Vertical Panel')}},
{	down = electric_commands.LeftGeneratorSw_EXT,	up = electric_commands.LeftGeneratorSw_EXT,		cockpit_device_id = devices.ELEC_INTERFACE, value_down = -1,	value_up = 0,	name = _('Left Generator Switch - Down'),		category = {_('Right Vertical Panel')}},
{	down = electric_commands.LeftGeneratorSw,														cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,					name = _('Left Generator Switch - L GEN'),		category = {_('Right Vertical Panel')}},
{	down = electric_commands.LeftGeneratorSw,														cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,					name = _('Left Generator Switch - OFF'),		category = {_('Right Vertical Panel')}},
{	down = electric_commands.LeftGenResetSw_EXT,	up = electric_commands.LeftGenResetSw_EXT,		cockpit_device_id = devices.ELEC_INTERFACE,	value_down = -1.0,	value_up = 0.0,	name = _('Left Generator Switch - RESET'),		category = {_('Right Vertical Panel')}},
{	down = electric_commands.RightGeneratorSw_EXT,	up = electric_commands.RightGeneratorSw_EXT,	cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		value_up = 0,	name = _('Right Generator Switch - Up'),		category = {_('Right Vertical Panel')}},
{	down = electric_commands.RightGeneratorSw_EXT,	up = electric_commands.RightGeneratorSw_EXT,	cockpit_device_id = devices.ELEC_INTERFACE, value_down = -1,	value_up = 0,	name = _('Right Generator Switch - Down'),		category = {_('Right Vertical Panel')}},
{	down = electric_commands.RightGeneratorSw,														cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,					name = _('Right Generator Switch - R GEN'),		category = {_('Right Vertical Panel')}},
{	down = electric_commands.RightGeneratorSw,														cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,					name = _('Right Generator Switch - OFF'),		category = {_('Right Vertical Panel')}},
{	down = electric_commands.RightGenResetSw_EXT,	up = electric_commands.RightGenResetSw_EXT,		cockpit_device_id = devices.ELEC_INTERFACE,	value_down = -1.0,	value_up = 0.0,	name = _('Right Generator Switch - RESET'),		category = {_('Right Vertical Panel')}},
--
{	down = cpt_commands.CanopyJettisonTHandle_EXT,	cockpit_device_id = devices.CPT_MECH,	value_down = 1.0,	name = _('Canopy Jettison T-Handle - PULL/PUSH'),	category = {_('Right Vertical Panel')}},
{	down = cpt_commands.CanopyJettisonTHandle,		cockpit_device_id = devices.CPT_MECH,	value_down = 1.0,	name = _('Canopy Jettison T-Handle - PULL'),		category = {_('Right Vertical Panel')}},
{	down = cpt_commands.CanopyJettisonTHandle,		cockpit_device_id = devices.CPT_MECH,	value_down = 0.0,	name = _('Canopy Jettison T-Handle - PUSH'),		category = {_('Right Vertical Panel')}},
-- Fuel System
{	down = fuel_commands.ExtFuelTransfer_Cl_EXT,										cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,					name = _('Ext Fuel Cl Switch - ON/OFF'),		category = {_('Right Vertical Panel')}},
{	down = fuel_commands.ExtFuelTransfer_Cl,											cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,					name = _('Ext Fuel Cl Switch - ON'),			category = {_('Right Vertical Panel')}},
{	down = fuel_commands.ExtFuelTransfer_Cl,											cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 0.0,					name = _('Ext Fuel Cl Switch - OFF'),			category = {_('Right Vertical Panel')}},
{	down = fuel_commands.ExtFuelTransfer_Pylon_EXT,										cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,					name = _('Ext Fuel Pylons Switch - ON/OFF'),	category = {_('Right Vertical Panel')}},
{	down = fuel_commands.ExtFuelTransfer_Pylon,											cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,					name = _('Ext Fuel Pylons Switch - ON'),		category = {_('Right Vertical Panel')}},
{	down = fuel_commands.ExtFuelTransfer_Pylon,											cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 0.0,					name = _('Ext Fuel Pylons Switch - OFF'),		category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelBoostPump_Left_EXT,										cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,					name = _('Left Boost Pump Switch - ON/OFF'),	category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelBoostPump_Left,											cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,					name = _('Left Boost Pump Switch - ON'),		category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelBoostPump_Left,											cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 0.0,					name = _('Left Boost Pump Switch - OFF'),		category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelCrossfeed_EXT,												cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,					name = _('Crossfeed Switch - OPEN/CLOSED'),		category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelCrossfeed,													cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,					name = _('Crossfeed Switch - OPEN'),			category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelCrossfeed,													cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 0.0,					name = _('Crossfeed Switch - CLOSED'),			category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelBoostPump_Right_EXT,										cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,					name = _('Right Boost Pump Switch - ON/OFF'),	category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelBoostPump_Right,											cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,					name = _('Right Boost Pump Switch - ON'),		category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelBoostPump_Right,											cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 0.0,					name = _('Right Boost Pump Switch - OFF'),		category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelAutoLeft,				up = fuel_commands.FuelAutoLeft,	cockpit_device_id = devices.FUEL_INTERFACE,	value_down = -1.0,	value_up = 0.0,	name = _('Autobalance Switch - LEFT/NEUT'),		category = {_('Right Vertical Panel')}},
{	down = fuel_commands.FuelAutoRight,				up = fuel_commands.FuelAutoRight,	cockpit_device_id = devices.FUEL_INTERFACE,	value_down = 1.0,	value_up = 0.0,	name = _('Autobalance Switch - RIGHT/NEUT'),	category = {_('Right Vertical Panel')}},
-- Anti-Ice
{	down = electric_commands.PitotHeater_EXT,	cockpit_device_id = devices.ELEC_INTERFACE,		value_down = 1.0,	name = _('Pitot Anti-Ice Switch - PITOT/OFF'),		category = {_('Right Vertical Panel')}},
{	down = electric_commands.PitotHeater,		cockpit_device_id = devices.ELEC_INTERFACE,		value_down = 1.0,	name = _('Pitot Anti-Ice Switch - PITOT'),			category = {_('Right Vertical Panel')}},
{	down = electric_commands.PitotHeater,		cockpit_device_id = devices.ELEC_INTERFACE,		value_down = 0.0,	name = _('Pitot Anti-Ice Switch - OFF'),			category = {_('Right Vertical Panel')}},
{	down = engine_commands.EngineAntiIce_EXT,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 1.0,	name = _('Engine Anti-Ice Switch - ENGINE/OFF'),	category = {_('Right Vertical Panel')}},
{	down = engine_commands.EngineAntiIce,		cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 1.0,	name = _('Engine Anti-Ice Switch - ENGINE'),		category = {_('Right Vertical Panel')}},
{	down = engine_commands.EngineAntiIce,		cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 0.0,	name = _('Engine Anti-Ice Switch - OFF'),			category = {_('Right Vertical Panel')}},
-- ECS
{	down = ecs_commands.CabinTempSw_EXT,			cockpit_device_id = devices.ECS_INTERFACE,	value_down = -1.0,		name = _('Cabin Temperature Switch - CW'),				category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinTempSw_EXT,			cockpit_device_id = devices.ECS_INTERFACE,	value_down =  1.0,		name = _('Cabin Temperature Switch - CCW'),				category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinTempSw,				cockpit_device_id = devices.ECS_INTERFACE,	value_down = 0.1,		name = _('Cabin Temperature Switch - CENTER'),			category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinTempSw,				cockpit_device_id = devices.ECS_INTERFACE,	value_down = 0.0,		name = _('Cabin Temperature Switch - AUTO'),			category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinTempSw,				cockpit_device_id = devices.ECS_INTERFACE,	value_down = 0.2,		name = _('Cabin Temperature Switch - MAN COLD'),		category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinTempSw,				cockpit_device_id = devices.ECS_INTERFACE,	value_down = 0.4,		name = _('Cabin Temperature Switch - MAN HOT'),			category = {_('Right Vertical Panel')}},
{	pressed = ecs_commands.CabinTempKnob_EXT,		cockpit_device_id = devices.ECS_INTERFACE,	value_pressed = -1.0,	name = _('Cabin Temperature Knob - CCW/Decrease'),		category = {_('Right Vertical Panel')}},
{	pressed = ecs_commands.CabinTempKnob_EXT,		cockpit_device_id = devices.ECS_INTERFACE,	value_pressed =  1.0,	name = _('Cabin Temperature Knob - CW/Increase'),		category = {_('Right Vertical Panel')}},
{	pressed = ecs_commands.CanopyDefog_EXT,			cockpit_device_id = devices.ECS_INTERFACE,	value_pressed = -1.0,	name = _('Canopy Defog Knob - CCW/Decrease'),			category = {_('Right Vertical Panel')}},
{	pressed = ecs_commands.CanopyDefog_EXT,			cockpit_device_id = devices.ECS_INTERFACE,	value_pressed =  1.0,	name = _('Canopy Defog Knob - CW/Increase'),			category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinPressCover_EXT,		cockpit_device_id = devices.ECS_INTERFACE,	value_down = 1.0,		name = _('Cabin Pressure Switch Cover - OPEN/CLOSE'),	category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinPressCover,			cockpit_device_id = devices.ECS_INTERFACE,	value_down = 1.0,		name = _('Cabin Pressure Switch Cover - OPEN'),			category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinPressCover,			cockpit_device_id = devices.ECS_INTERFACE,	value_down = 0.0,		name = _('Cabin Pressure Switch Cover - CLOSE'),		category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinPress_EXT,				cockpit_device_id = devices.ECS_INTERFACE,	value_down = 1.0,		name = _('Cabin Pressure Switch - Up'),					category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinPress_EXT,				cockpit_device_id = devices.ECS_INTERFACE,	value_down = -1.0,		name = _('Cabin Pressure Switch - Down'),				category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinPress,					cockpit_device_id = devices.ECS_INTERFACE,	value_down = 1.0,		name = _('Cabin Pressure Switch - RAM DUMP'),			category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinPress,					cockpit_device_id = devices.ECS_INTERFACE,	value_down = 0.0,		name = _('Cabin Pressure Switch - NORMAL'),				category = {_('Right Vertical Panel')}},
{	down = ecs_commands.CabinPress,					cockpit_device_id = devices.ECS_INTERFACE,	value_down = -1.0,		name = _('Cabin Pressure Switch - DEFOG ONLY'),			category = {_('Right Vertical Panel')}},
{	pressed = ecs_commands.CockpitAirInletHor_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed = -0.2,	name = _('Cockpit Right Air Inlet - Left'),				category = {_('Right Vertical Panel')}},
{	pressed = ecs_commands.CockpitAirInletHor_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed =  0.2,	name = _('Cockpit Right Air Inlet - Right'),			category = {_('Right Vertical Panel')}},
{	pressed = ecs_commands.CockpitAirInletVer_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed = -0.2,	name = _('Cockpit Right Air Inlet - Down'),				category = {_('Right Vertical Panel')}},
{	pressed = ecs_commands.CockpitAirInletVer_EXT,	cockpit_device_id = devices.ECS_INTERFACE,	value_pressed =  0.2,	name = _('Cockpit Right Air Inlet - Up'),				category = {_('Right Vertical Panel')}},

---------------------------------------------
-- Right Panels -----------------------------
---------------------------------------------
-- Lighting Control Panel
{	down = intlights_commands.WarningTest,	up = intlights_commands.WarningTest,	cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_down = 1.0,  value_up = 0.0,	name = _('Warning Lights Test Switch - TEST/OFF'),			category = {_('Right Panels'), _('Lighting Control Panel')}},
{	down = intlights_commands.Brt,			up = intlights_commands.Brt,			cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_down = 1.0,  value_up = 0.0,	name = _('Warning Lights Brightness Switch - BRT/OFF'),		category = {_('Right Panels'), _('Lighting Control Panel')}},
{	down = intlights_commands.Dim,			up = intlights_commands.Dim,			cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_down = -1.0, value_up = 0.0,	name = _('Warning Lights Brightness Switch - DIM/OFF'),		category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = extlights_commands.NavKnob_EXT,										cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	value_pressed = -1.0,				name = _('Exterior Lights Nav Knob - CCW/Decrease'),		category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = extlights_commands.NavKnob_EXT,										cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	value_pressed =  1.0,				name = _('Exterior Lights Nav Knob - CW/Increase'),			category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = extlights_commands.Formation_EXT,										cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	value_pressed = -1.0,				name = _('Exterior Lights Formation Knob - CCW/Decrease'),	category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = extlights_commands.Formation_EXT,										cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	value_pressed =  1.0,				name = _('Exterior Lights Formation Knob - CW/Increase'),	category = {_('Right Panels'), _('Lighting Control Panel')}},
{	down = extlights_commands.Beacon_EXT,											cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	value_down = 1.0,					name = _('Exterior Lights Beacon Switch - ON/OFF'),			category = {_('Right Panels'), _('Lighting Control Panel')}},
{	down = extlights_commands.Beacon,												cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	value_down = 1.0,					name = _('Exterior Lights Beacon Switch - ON'),				category = {_('Right Panels'), _('Lighting Control Panel')}},
{	down = extlights_commands.Beacon,												cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	value_down = 0.0,					name = _('Exterior Lights Beacon Switch - OFF'),			category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = intlights_commands.Flood_knob_EXT,									cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_pressed = -1.0,				name = _('Flood Lights Knob - CCW/Decrease'),				category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = intlights_commands.Flood_knob_EXT,									cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_pressed =  1.0,				name = _('Flood Lights Knob - CW/Increase'),				category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = intlights_commands.FltInstr_knob_EXT,									cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_pressed = -1.0,				name = _('Flight Instruments Lights Knob - CCW/Decrease'),	category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = intlights_commands.FltInstr_knob_EXT,									cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_pressed =  1.0,				name = _('Flight Instruments Lights Knob - CW/Increase'),	category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = intlights_commands.EngInstr_knob_EXT,									cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_pressed = -1.0,				name = _('Engine Instruments Lights Knob - CCW/Decrease'),	category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = intlights_commands.EngInstr_knob_EXT,									cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_pressed =  1.0,				name = _('Engine Instruments Lights Knob - CW/Increase'),	category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = intlights_commands.Console_knob_EXT,									cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_pressed = -1.0,				name = _('Console Lights Knob - CCW/Decrease'),				category = {_('Right Panels'), _('Lighting Control Panel')}},
{	pressed = intlights_commands.Console_knob_EXT,									cockpit_device_id = devices.INTLIGHTS_SYSTEM,	value_pressed =  1.0,				name = _('Console Lights Knob - CW/Increase'),				category = {_('Right Panels'), _('Lighting Control Panel')}},
--
{	down = electric_commands.GageTest,	up = electric_commands.GageTest,	cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1,		value_up = 0,	name = _('Fuel & Oxygen Switch - GAGE TEST/OFF'),	category = {_('Right Vertical Panel')}},
{	down = electric_commands.QtyCheck,	up = electric_commands.QtyCheck,	cockpit_device_id = devices.ELEC_INTERFACE,	value_down = -1,	value_up = 0,	name = _('Fuel & Oxygen Switch - QTY CHECK/OFF'),	category = {_('Right Vertical Panel')}},
-- GMC
{	down = ahrs_commands.AHRS_CMD_COMPASS_EXT,				up = ahrs_commands.AHRS_CMD_COMPASS_EXT,			cockpit_device_id = devices.AHRS,	value_down = 1,		value_up = 0,	name = _('Compass Switch - Up'),			category = {_('Right Vertical Panel')}},
{	down = ahrs_commands.AHRS_CMD_COMPASS_EXT,				up = ahrs_commands.AHRS_CMD_COMPASS_EXT,			cockpit_device_id = devices.AHRS,	value_down = -1,	value_up = 0,	name = _('Compass Switch - Down'),			category = {_('Right Vertical Panel')}},
{	down = ahrs_commands.AHRS_CMD_COMPASS,																		cockpit_device_id = devices.AHRS,	value_down = 1.0,					name = _('Compass Switch - DIR GYRO'),		category = {_('Right Vertical Panel')}},
{	down = ahrs_commands.AHRS_CMD_COMPASS,																		cockpit_device_id = devices.AHRS,	value_down = 0.0,					name = _('Compass Switch - MAG'),			category = {_('Right Vertical Panel')}},
{	down = ahrs_commands.AHRS_CMD_COMPASS_FAST_SLAVE_EXT,	up = ahrs_commands.AHRS_CMD_COMPASS_FAST_SLAVE_EXT,	cockpit_device_id = devices.AHRS,	value_down = -1.0,	value_up = 0.0,	name = _('Compass Switch - FAST SLAVE'),	category = {_('Right Vertical Panel')}},
-- Oxygen Control Panel
{	down = oxygen_commands.SupplyLever_EXT,			cockpit_device_id = devices.OXYGEN_INTERFACE,	value_down = 1.0,		name = _('Oxygen Supply Lever - ON/OFF'),			category = {_('Right Panels'), _('Oxygen Control Panel')}},
{	down = oxygen_commands.SupplyLever,				cockpit_device_id = devices.OXYGEN_INTERFACE,	value_down = 1.0,		name = _('Oxygen Supply Lever - ON'),				category = {_('Right Panels'), _('Oxygen Control Panel')}},
{	down = oxygen_commands.SupplyLever,				cockpit_device_id = devices.OXYGEN_INTERFACE,	value_down = 0.0,		name = _('Oxygen Supply Lever - OFF'),				category = {_('Right Panels'), _('Oxygen Control Panel')}},
{	pressed = oxygen_commands.DiluterLever_EXT,		cockpit_device_id = devices.OXYGEN_INTERFACE,	value_pressed = -1.0,	name = _('Oxygen Diluter Lever - Down/Decrease'),	category = {_('Right Panels'), _('Oxygen Control Panel')}},
{	pressed = oxygen_commands.DiluterLever_EXT,		cockpit_device_id = devices.OXYGEN_INTERFACE,	value_pressed =  1.0,	name = _('Oxygen Diluter Lever - Up/Increase'),		category = {_('Right Panels'), _('Oxygen Control Panel')}},
{	down = oxygen_commands.EmergLever_EXT,			up = oxygen_commands.EmergLever_EXT,		cockpit_device_id = devices.OXYGEN_INTERFACE,	value_down =  1,	value_up = 0,	name = _('Oxygen Emergency Lever - Up'),			category = {_('Right Panels'), _('Oxygen Control Panel')}},
{	down = oxygen_commands.EmergLever_EXT,			up = oxygen_commands.EmergLever_EXT,		cockpit_device_id = devices.OXYGEN_INTERFACE,	value_down = -1,	value_up = 0,	name = _('Oxygen Emergency Lever - Down'),			category = {_('Right Panels'), _('Oxygen Control Panel')}},
{	down = oxygen_commands.EmergLever,															cockpit_device_id = devices.OXYGEN_INTERFACE,	value_down =  1,					name = _('Oxygen Emergency Lever - EMERGENCY'),		category = {_('Right Panels'), _('Oxygen Control Panel')}},
{	down = oxygen_commands.EmergLever,															cockpit_device_id = devices.OXYGEN_INTERFACE,	value_down =  0,					name = _('Oxygen Emergency Lever - NORMAL'),		category = {_('Right Panels'), _('Oxygen Control Panel')}},
{	down = oxygen_commands.EmergLeverTest_EXT,		up = oxygen_commands.EmergLeverTest_EXT,	cockpit_device_id = devices.OXYGEN_INTERFACE,	value_down = -1,	value_up = 0,	name = _('Oxygen Emergency Lever - TEST MASK'),		category = {_('Right Panels'), _('Oxygen Control Panel')}},
-- IFF/SIF
{	down = device_commands.Button_22,	up = device_commands.Button_22,	cockpit_device_id = devices.IFF,	value_down =  1,	value_up = 0,	name = _('IFF MODE 4 CODE Selector (Press to pull switch)'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_7,									cockpit_device_id = devices.IFF,	value_down =  1,	value_up = 0,	name = _('IFF MODE 4 CODE Selector - CW'),								category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_7,									cockpit_device_id = devices.IFF,	value_down = -1,	value_up = 0,	name = _('IFF MODE 4 CODE Selector - CCW'),								category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_23,	up = device_commands.Button_23,	cockpit_device_id = devices.IFF,	value_down =  1,	value_up = 0,	name = _('IFF MASTER Control Selector (Press to pull switch)'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_38,									cockpit_device_id = devices.IFF,	value_down =  1,	value_up = 0,	name = _('IFF MASTER Control Selector - CW'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_38,									cockpit_device_id = devices.IFF,	value_down = -1,	value_up = 0,	name = _('IFF MASTER Control Selector - CCW'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_8,									cockpit_device_id = devices.IFF,	value_down = 0.4,					name = _('IFF MASTER Control Selector - EMER'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_8,									cockpit_device_id = devices.IFF,	value_down = 0.3,					name = _('IFF MASTER Control Selector - NORM'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_8,									cockpit_device_id = devices.IFF,	value_down = 0.2,					name = _('IFF MASTER Control Selector - LOW'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_8,									cockpit_device_id = devices.IFF,	value_down = 0.1,					name = _('IFF MASTER Control Selector - STBY'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_8,									cockpit_device_id = devices.IFF,	value_down = 0.0,					name = _('IFF MASTER Control Selector - OFF'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_37,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF MODE 4 Monitor Control Switch - Up'),						category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_37,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF MODE 4 Monitor Control Switch - Down'),					category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_9,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF MODE 4 Monitor Control Switch - AUDIO'),					category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_9,									cockpit_device_id = devices.IFF,	value_down =  0,					name = _('IFF MODE 4 Monitor Control Switch - OUT'),					category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_9,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF MODE 4 Monitor Control Switch - LIGHT'),					category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_31,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF Mode Select/TEST Switch (M-1) - ON/OUT'),					category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_10,	up = device_commands.Button_10,	cockpit_device_id = devices.IFF,	value_down =  1,	value_up = 0,	name = _('IFF Mode Select/TEST Switch - M-1'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_32,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF Mode Select/TEST Switch (M-2) - ON/OUT'),					category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_11,	up = device_commands.Button_11,	cockpit_device_id = devices.IFF,	value_down =  1,	value_up = 0,	name = _('IFF Mode Select/TEST Switch - M-2'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_33,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF Mode Select/TEST Switch (M-3/A) - ON/OUT'),				category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_12,	up = device_commands.Button_12,	cockpit_device_id = devices.IFF,	value_down =  1,	value_up = 0,	name = _('IFF Mode Select/TEST Switch - M-3/A'),						category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_34,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF Mode Select/TEST Switch (M-C) - ON/OUT'),					category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_13,	up = device_commands.Button_13,	cockpit_device_id = devices.IFF,	value_down =  1,	value_up = 0,	name = _('IFF Mode Select/TEST Switch - M-C'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_14,	up = device_commands.Button_14,	cockpit_device_id = devices.IFF,	value_down =  1,	value_up = 0,	name = _('IFF RAD TEST/MON Switch - RAD TEST'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_35,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF RAD TEST/MON Switch - OUT/MON'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_15,	up = device_commands.Button_15,	cockpit_device_id = devices.IFF,	value_down =  1,	value_up = 0,	name = _('IFF Identification of Position (IP) Switch - IDENT'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_36,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF Identification of Position (IP) Switch - OUT/MIC'),		category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_30,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF MODE 4 Control Switch - ON/OUT'),							category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_24,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF MODE 1 Code Selector Wheel 1 - Up/Increase'),				category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_24,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF MODE 1 Code Selector Wheel 1 - Down/Decrease'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_25,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF MODE 1 Code Selector Wheel 2 - Up/Increase'),				category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_25,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF MODE 1 Code Selector Wheel 2 - Down/Decrease'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_26,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF MODE 3/A Code Selector Wheel 1 - Up/Increase'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_26,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF MODE 3/A Code Selector Wheel 1 - Down/Decrease'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_27,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF MODE 3/A Code Selector Wheel 2 - Up/Increase'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_27,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF MODE 3/A Code Selector Wheel 2 - Down/Decrease'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_28,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF MODE 3/A Code Selector Wheel 3 - Up/Increase'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_28,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF MODE 3/A Code Selector Wheel 3 - Down/Decrease'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_29,									cockpit_device_id = devices.IFF,	value_down =  1,					name = _('IFF MODE 3/A Code Selector Wheel 4 - Up/Increase'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_29,									cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF MODE 3/A Code Selector Wheel 4 - Down/Decrease'),			category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_17,	up = device_commands.Button_17,	cockpit_device_id = devices.IFF,	value_down = 1,		value_up = 0,	name = _('IFF MODE 4 REPLY Light (Press to test)'),						category = {_('Right Panels'), _('IFF Controls')}},
{	down = device_commands.Button_18,	up = device_commands.Button_18,	cockpit_device_id = devices.IFF,	value_down = 1,		value_up = 0,	name = _('IFF Radiation TEST and Monitor Light (Press to test)'),		category = {_('Right Panels'), _('IFF Controls')}},


---------------------------------------------
-- Pedestal Panels --------------------------
---------------------------------------------
-- UHF Radio ARC-164 Control Panel
{	down = iCommandPlaneUHFPresetChannelSelectorDec,																							name = _('UHF Radio Preset Chanel Selector - Decrease'),		category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHFPresetChannelSelectorInc,																							name = _('UHF Radio Preset Chanel Selector - Increase'),		category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_20,									cockpit_device_id = devices.UHF_RADIO,	value_down = -1,				name = _('UHF Radio 100Mhz Selector Switch - CW/Increase'),		category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_20,									cockpit_device_id = devices.UHF_RADIO,	value_down = 1,					name = _('UHF Radio 100Mhz Selector Switch - CCW/Decrease'),	category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF100MhzSelector1,																										name = _('UHF Radio 100Mhz Selector Switch - T'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF100MhzSelector2,																										name = _('UHF Radio 100Mhz Selector Switch - 2'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF100MhzSelector3,																										name = _('UHF Radio 100Mhz Selector Switch - 3'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF100MhzSelectorA,																										name = _('UHF Radio 100Mhz Selector Switch - A'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF10MhzSelectorDec,																									name = _('UHF Radio 10Mhz Selector - Decrease'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF10MhzSelectorInc,																									name = _('UHF Radio 10Mhz Selector - Increase'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF1MhzSelectorDec,																										name = _('UHF Radio 1Mhz Selector - Decrease'),					category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF1MhzSelectorInc,																										name = _('UHF Radio 1Mhz Selector - Increase'),					category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF01MhzSelectorDec,																									name = _('UHF Radio 0.1Mhz Selector - Decrease'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF01MhzSelectorInc,																									name = _('UHF Radio 0.1Mhz Selector - Increase'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF0025MhzSelectorDec,																									name = _('UHF Radio 0.025Mhz Selector - Decrease'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHF0025MhzSelectorInc,																									name = _('UHF Radio 0.025Mhz Selector - Increase'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	pressed = iCommandPlaneUHFVolumeDec,																										name = _('UHF Radio Volume Knob - CCW/Decrease'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	pressed = iCommandPlaneUHFVolumeInc,																										name = _('UHF Radio Volume Knob - CW/Increase'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_18,									cockpit_device_id = devices.UHF_RADIO,	value_down = 1,					name = _('UHF Radio Function Selector Switch - CW'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_18,									cockpit_device_id = devices.UHF_RADIO,	value_down = -1,				name = _('UHF Radio Function Selector Switch - CCW'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHFFunctionDialOFF,																										name = _('UHF Radio Function Selector Switch - OFF'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHFFunctionDialMAIN,																									name = _('UHF Radio Function Selector Switch - MAIN'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHFFunctionDialBOTH,																									name = _('UHF Radio Function Selector Switch - BOTH'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHFFunctionDialADF,																										name = _('UHF Radio Function Selector Switch - ADF'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_19,									cockpit_device_id = devices.UHF_RADIO,	value_down = 1,					name = _('UHF Radio Frequency Mode Selector Switch - CW'),		category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_19,									cockpit_device_id = devices.UHF_RADIO,	value_down = -1,				name = _('UHF Radio Frequency Mode Selector Switch - CCW'),		category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHFFreqModeDialMNL,																										name = _('UHF Radio Frequency Mode Switch - MANUAL'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHFFreqModeDialPRESET,																									name = _('UHF Radio Frequency Mode Switch - PRESET'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHFFreqModeDialGRD,																										name = _('UHF Radio Frequency Mode Switch - GUARD'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHFTTone,		up = iCommandPlaneUHFTTone,												value_down = 1,	value_up = 0,	name = _('UHF Radio T-Tone Button'),							category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlaneUHFSquelch,																												name = _('UHF Radio Squelch Switch - ON/OFF'),					category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_10,									cockpit_device_id = devices.UHF_RADIO,	value_down = 1,					name = _('UHF Radio Squelch Switch - ON'),						category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_10,									cockpit_device_id = devices.UHF_RADIO,	value_down = 0,					name = _('UHF Radio Squelch Switch - OFF'),						category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_21,									cockpit_device_id = devices.UHF_RADIO,	value_down = 1,					name = _('UHF Radio Antenna Selector Switch - Up'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_21,									cockpit_device_id = devices.UHF_RADIO,	value_down = -1,				name = _('UHF Radio Antenna Selector Switch - Down'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_16,									cockpit_device_id = devices.UHF_RADIO,	value_down = 1.0,				name = _('UHF Radio Antenna Selector Switch - UPPER'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_16,									cockpit_device_id = devices.UHF_RADIO,	value_down = 0.5,				name = _('UHF Radio Antenna Selector Switch - AUTO'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_16,									cockpit_device_id = devices.UHF_RADIO,	value_down = 0.0,				name = _('UHF Radio Antenna Selector Switch - LOWER'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{combos = {{key = "JOY_BTN3"}},	down = device_commands.Button_1,	up = device_commands.Button_1,	cockpit_device_id = devices.INTERCOM,	value_down = 1,	value_up = 0,	name = _('UHF Radio Microphone Button'),						category = {_('UHF Radio ARC-164 Control Panel'), _('Throttle Quadrant')}},
{	down = device_commands.Button_23,									cockpit_device_id = devices.UHF_RADIO,	value_down = 1,					name = _('UHF Radio Hinged Access Door - OPEN/CLOSE'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_22,									cockpit_device_id = devices.UHF_RADIO,	value_down = 1,					name = _('UHF Radio Hinged Access Door - OPEN'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_22,									cockpit_device_id = devices.UHF_RADIO,	value_down = 0,					name = _('UHF Radio Hinged Access Door - CLOSE'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_24,	up = device_commands.Button_24,	cockpit_device_id = devices.UHF_RADIO,	value_down = 1,	value_up = 0,	name = _('UHF Radio Preset Channel Set Button'),				category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},
-- ARN-118 TACAN Control Panel
{	down = device_commands.Button_7,	cockpit_device_id = devices.TACAN_CTRL_PANEL,	value_down = 1,		name = _('TACAN Mode Selector Switch - CW'),			category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	down = device_commands.Button_7,	cockpit_device_id = devices.TACAN_CTRL_PANEL,	value_down = -1,	name = _('TACAN Mode Selector Switch - CCW'),			category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlane_TACAN_Mode_Off, 																	name = _('TACAN Mode Selector Switch - OFF'),			category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlane_TACAN_Mode_Rec, 																	name = _('TACAN Mode Selector Switch - REC'),			category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlane_TACAN_Mode_TR, 																	name = _('TACAN Mode Selector Switch - T/R'),			category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlane_TACAN_Mode_AAREC, 																	name = _('TACAN Mode Selector Switch - A/A REC'),		category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlane_TACAN_Mode_AATR, 																	name = _('TACAN Mode Selector Switch - A/A T/R'),		category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	pressed = iCommandPlane_TACAN_Volume_Decrease, 															name = _('TACAN Volume - Decrease'),					category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	pressed = iCommandPlane_TACAN_Volume_Increase, 															name = _('TACAN Volume - Increase'),					category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	pressed = iCommandPlane_TACAN_Chanel_Ones_Decrease,														name = _('TACAN Channel Selector (Ones) - Decrease'),	category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	pressed = iCommandPlane_TACAN_Chanel_Ones_Increase,														name = _('TACAN Channel Selector (Ones) - Increase'),	category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	pressed = iCommandPlane_TACAN_Chanel_Tens_Decrease,														name = _('TACAN Channel Selector (Tens) - Decrease'),	category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	pressed = iCommandPlane_TACAN_Chanel_Tens_Increase,														name = _('TACAN Channel Selector (Tens) - Increase'),	category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlane_TACAN_Chanel_XY_Mode, 																name = _('TACAN Mode X/Y Switch'),						category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
{	down = iCommandPlane_TACAN_Test, up=iCommandPlane_TACAN_Test,	value_down = 1,	value_up = 0,			name = _('TACAN Test Button'),							category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
--
{	down = ahrs_commands.AHRS_NAV_MODE_EXT,	cockpit_device_id = devices.AHRS,	value_down = 1.0,	name = _('Nav Mode Selector Switch - DF/TACAN'),	category = {_('Pedestal Panels')}},
{	down = ahrs_commands.AHRS_NAV_MODE,		cockpit_device_id = devices.AHRS,	value_down = 0.0,	name = _('Nav Mode Selector Switch - DF'),			category = {_('Pedestal Panels')}},
{	down = ahrs_commands.AHRS_NAV_MODE,		cockpit_device_id = devices.AHRS,	value_down = 0.1,	name = _('Nav Mode Selector Switch - TACAN'),		category = {_('Pedestal Panels')}},
--
{	down = control_commands.RudderPedalAdjust_EXT,	cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0,	name = _('Rudder Pedal Adjust T-Handle - PULL/STOW'),	category = {_('Pedestal Panels')}},
{	down = control_commands.RudderPedalAdjust,		cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 1.0,	name = _('Rudder Pedal Adjust T-Handle - PULL'),		category = {_('Pedestal Panels')}},
{	down = control_commands.RudderPedalAdjust,		cockpit_device_id = devices.CONTROL_INTERFACE,	value_down = 0.0,	name = _('Rudder Pedal Adjust T-Handle - STOW'),		category = {_('Pedestal Panels')}},

---------------------------------------------
-- Circuit Breaker Panels -------------------
---------------------------------------------
-- Left CB Panels
{	down = electric_commands.CB_LEFT_AIM9_POWER + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LEFT AIM-9 POWER - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_AIM9_POWER,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LEFT AIM-9 POWER - ON'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_AIM9_POWER,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB LEFT AIM-9 POWER - OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_GUN_FIRING + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LEFT GUN FIRING - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_GUN_FIRING,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LEFT GUN FIRING - ON'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_GUN_FIRING,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB LEFT GUN FIRING - OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_26_AC_POWER + CB_commands_num,					cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB 26 VOLT AC POWER - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_26_AC_POWER,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB 26 VOLT AC POWER - ON'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_26_AC_POWER,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB 26 VOLT AC POWER - OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ATTD_HDG_REF_SYS_A + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB ATTD & HDG REF SYS A - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ATTD_HDG_REF_SYS_A,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB ATTD & HDG REF SYS A - ON'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ATTD_HDG_REF_SYS_A,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB ATTD & HDG REF SYS A - OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_CADC + CB_commands_num,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB CENTRAL AIR DATA COMPUTER - ON/OFF'),			category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_CADC,											cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB CENTRAL AIR DATA COMPUTER - ON'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_CADC,											cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB CENTRAL AIR DATA COMPUTER - OFF'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ENG_IGN_INST_HYD_IND + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB ENG IGN L ENG INST & HYD IND - ON/OFF'),		category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ENG_IGN_INST_HYD_IND,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB ENG IGN L ENG INST & HYD IND - ON'),			category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ENG_IGN_INST_HYD_IND,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB ENG IGN L ENG INST & HYD IND - OFF'),			category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_AIM9_POWER + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB RIGHT AIM-9 POWER - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_AIM9_POWER,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB RIGHT AIM-9 POWER - ON'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_AIM9_POWER,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB RIGHT AIM-9 POWER - OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_GUN_FIRING + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB RIGHT GUN FIRING - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_GUN_FIRING,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB RIGHT GUN FIRING - ON'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_GUN_FIRING,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB RIGHT GUN FIRING - OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_TRIM_CONTROL + CB_commands_num,					cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB TRIM CONTROL - ON/OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_TRIM_CONTROL,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB TRIM CONTROL - ON'),							category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_TRIM_CONTROL,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB TRIM CONTROL - OFF'),							category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ATTD_HDG_REF_SYS_B + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB ATTD & HDG REF SYS B - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ATTD_HDG_REF_SYS_B,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB ATTD & HDG REF SYS B - ON'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ATTD_HDG_REF_SYS_B,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB ATTD & HDG REF SYS B - OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_TOTAL_TEMP_PROBE_HTR + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB TOTAL TEMP PROBE HTR - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_TOTAL_TEMP_PROBE_HTR,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB TOTAL TEMP PROBE HTR - ON'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_TOTAL_TEMP_PROBE_HTR,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB TOTAL TEMP PROBE HTR - OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_L_ENG_AUX_DOOR + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB L ENG AUX DOOR - ON/OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_L_ENG_AUX_DOOR,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB L ENG AUX DOOR - ON'),							category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_L_ENG_AUX_DOOR,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB L ENG AUX DOOR - OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_CABIN_COND + CB_commands_num,					cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB CABIN COND - ON/OFF'),							category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_CABIN_COND,										cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB CABIN COND - ON'),								category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_CABIN_COND,										cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB CABIN COND - OFF'),							category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_FUEL_QTY_PRIMARY + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB FUEL QTY PRIMARY - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_FUEL_QTY_PRIMARY,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB FUEL QTY PRIMARY - ON'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_FUEL_QTY_PRIMARY,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB FUEL QTY PRIMARY - OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ATTD_HDG_REF_SYS_C + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB ATTD & HDG REF SYS C - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ATTD_HDG_REF_SYS_C,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB ATTD & HDG REF SYS C - ON'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_ATTD_HDG_REF_SYS_C,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB ATTD & HDG REF SYS C - OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_TACAN + CB_commands_num,						cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB TACAN - ON/OFF'),								category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_TACAN,											cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB TACAN - ON'),									category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_TACAN,											cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB TACAN - OFF'),									category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_PYLON_TANK_FUEL_CONT + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB PYLON TANK FUEL CONT - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_PYLON_TANK_FUEL_CONT,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB PYLON TANK FUEL CONT - ON'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_PYLON_TANK_FUEL_CONT,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB PYLON TANK FUEL CONT - OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_L_BOOST_CL_TANK_FUEL_CONT + CB_commands_num,	cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB L BOOST CL & TIP TANK FUEL CONT - ON/OFF'),	category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_L_BOOST_CL_TANK_FUEL_CONT,						cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB L BOOST CL & TIP TANK FUEL CONT - ON'),		category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_L_BOOST_CL_TANK_FUEL_CONT,						cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB L BOOST CL & TIP TANK FUEL CONT - OFF'),		category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_IGN_INVERTER_POWER + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB IGNITION INVERTER POWER - ON/OFF'),			category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_IGN_INVERTER_POWER,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB IGNITION INVERTER POWER - ON'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_IGN_INVERTER_POWER,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB IGNITION INVERTER POWER - OFF'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_L_ENG_START_AB_CONT + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB L ENG START & AB CONT - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_L_ENG_START_AB_CONT,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB L ENG START & AB CONT - ON'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_L_ENG_START_AB_CONT,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB L ENG START & AB CONT - OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_R_ENG_START_AB_CONT + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB R ENG START & AB CONT - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_R_ENG_START_AB_CONT,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB R ENG START & AB CONT - ON'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_R_ENG_START_AB_CONT,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB R ENG START & AB CONT - OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_UHF_COMMAND_RADIO + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB UHF COMMAND RADIO - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_UHF_COMMAND_RADIO,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB UHF COMMAND RADIO - ON'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_UHF_COMMAND_RADIO,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB UHF COMMAND RADIO - OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_LE_FLAP_CONT + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LEFT LE FLAP CONT - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_LE_FLAP_CONT,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LEFT LE FLAP CONT - ON'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_LE_FLAP_CONT,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB LEFT LE FLAP CONT - OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_LE_FLAP_CONT + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB RIGHT LE FLAP CONT - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_LE_FLAP_CONT,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB RIGHT LE FLAP CONT - ON'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_LE_FLAP_CONT,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB RIGHT LE FLAP CONT - OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_TE_FLAP_CONT + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LEFT TE FLAP CONT - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_TE_FLAP_CONT,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LEFT TE FLAP CONT - ON'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_LEFT_TE_FLAP_CONT,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB LEFT TE FLAP CONT - OFF'),						category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_TE_FLAP_CONT + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB RIGHT TE FLAP CONT & IND - ON/OFF'),			category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_TE_FLAP_CONT,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB RIGHT TE FLAP CONT & IND - ON'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
{	down = electric_commands.CB_RIGHT_TE_FLAP_CONT,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB RIGHT TE FLAP CONT & IND - OFF'),				category = {_('Circuit Breaker Panels'), _('Left CB Panels')}},
-- Front CB Panel
{	down = electric_commands.CB_WPN_PWR_LEFT_INBD + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN PWR LEFT INBD - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_LEFT_INBD,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN PWR LEFT INBD - ON'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_LEFT_INBD,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB WPN PWR LEFT INBD - OFF'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_CENTER_LINE + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN PWR CENTER LINE - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_CENTER_LINE,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN PWR CENTER LINE - ON'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_CENTER_LINE,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB WPN PWR CENTER LINE - OFF'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_RIGHT_INBD + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN PWR RIGHT INBD - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_RIGHT_INBD,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN PWR RIGHT INBD - ON'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_RIGHT_INBD,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB WPN PWR RIGHT INBD - OFF'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_LEFT_OUTBD + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN PWR LEFT OUTBD - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_LEFT_OUTBD,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN PWR LEFT OUTBD - ON'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_LEFT_OUTBD,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB WPN PWR LEFT OUTBD - OFF'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_ARMING + CB_commands_num,					cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN ARMING - ON/OFF'),							category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_ARMING,										cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN ARMING - ON'),								category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_ARMING,										cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB WPN ARMING - OFF'),							category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_RIGHT_OUTBD + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN PWR RIGHT OUTBD - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_RIGHT_OUTBD,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN PWR RIGHT OUTBD - ON'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_PWR_RIGHT_OUTBD,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB WPN PWR RIGHT OUTBD - OFF'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_JETTISON_CONTROL + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB JETTISON CONTROL - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_JETTISON_CONTROL,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB JETTISON CONTROL - ON'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_JETTISON_CONTROL,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB JETTISON CONTROL - OFF'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_RELEASE + CB_commands_num,					cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN RELEASE - ON/OFF'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_RELEASE,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN RELEASE - ON'),							category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_RELEASE,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB WPN RELEASE - OFF'),							category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_MODE_SEL + CB_commands_num,					cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN MODE SEL & AIM-9-INTLK - ON/OFF'),			category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_MODE_SEL,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB WPN MODE SEL & AIM-9-INTLK - ON'),				category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_WPN_MODE_SEL,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB WPN MODE SEL & AIM-9-INTLK - OFF'),			category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_EMERG_ALL_JETTISON + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB EMERGENCY ALL JETTISON - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_EMERG_ALL_JETTISON,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB EMERGENCY ALL JETTISON - ON'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_EMERG_ALL_JETTISON,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB EMERGENCY ALL JETTISON - OFF'),				category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_LEFT_AIM9_CONT + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LEFT AIM-9 CONT - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_LEFT_AIM9_CONT,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LEFT AIM-9 CONT - ON'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_LEFT_AIM9_CONT,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB LEFT AIM-9 CONT - OFF'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_RIGHT_AIM9_CONT + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB RIGHT AIM-9 CONT - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_RIGHT_AIM9_CONT,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB RIGHT AIM-9 CONT - ON'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
{	down = electric_commands.CB_RIGHT_AIM9_CONT,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB RIGHT AIM-9 CONT - OFF'),						category = {_('Circuit Breaker Panels'), _('Front CB Panel')}},
-- Right CB Panel
{	down = electric_commands.CB_PITOT_HEATER + CB_commands_num,					cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB PITOT HEATER - ON/OFF'),						category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_PITOT_HEATER,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB PITOT HEATER - ON'),							category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_PITOT_HEATER,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB PITOT HEATER - OFF'),							category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_R_OIL_HYD_IND_FUEL_QTY_SEC + CB_commands_num,	cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB R OIL & HYD IND FUEL QTY SEL - ON/OFF'),		category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_R_OIL_HYD_IND_FUEL_QTY_SEC,						cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB R OIL & HYD IND FUEL QTY SEL - ON'),			category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_R_OIL_HYD_IND_FUEL_QTY_SEC,						cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB R OIL & HYD IND FUEL QTY SEL - OFF'),			category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_CABIN_AIR_VALVES + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB CABIN AIR VALVES - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_CABIN_AIR_VALVES,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB CABIN AIR VALVES - ON'),						category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_CABIN_AIR_VALVES,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB CABIN AIR VALVES - OFF'),						category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_INST_LIGHTS + CB_commands_num,					cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB INST LIGHTS - ON/OFF'),						category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_INST_LIGHTS,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB INST LIGHTS - ON'),							category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_INST_LIGHTS,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB INST LIGHTS - OFF'),							category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_R_ENG_AUX_DOOR + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB R ENG AUX DOORS - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_R_ENG_AUX_DOOR,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB R ENG AUX DOORS - ON'),						category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_R_ENG_AUX_DOOR,									cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB R ENG AUX DOORS - OFF'),						category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_CAUTION_WARN_DIM + CB_commands_num,				cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB CAUTION & WARN LIGHTS-DIM - ON/OFF'),			category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_CAUTION_WARN_DIM,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB CAUTION & WARN LIGHTS-DIM - ON'),				category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_CAUTION_WARN_DIM,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB CAUTION & WARN LIGHTS-DIM - OFF'),				category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_OXY_QTY_CANOPY_SEAL + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB OXY QTY & CANOPY SEAL - ON/OFF'),				category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_OXY_QTY_CANOPY_SEAL,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB OXY QTY & CANOPY SEAL - ON'),					category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_OXY_QTY_CANOPY_SEAL,							cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB OXY QTY & CANOPY SEAL - OFF'),					category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_LDG_TAXI_LAMP_PWR + CB_commands_num,			cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LDG-TAXI LAMP PWR - ON/OFF'),					category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_LDG_TAXI_LAMP_PWR,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 1.0,	name = _('CB LDG-TAXI LAMP PWR - ON'),						category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},
{	down = electric_commands.CB_LDG_TAXI_LAMP_PWR,								cockpit_device_id = devices.ELEC_INTERFACE,	value_down = 0.0,	name = _('CB LDG-TAXI LAMP PWR - OFF'),						category = {_('Circuit Breaker Panels'), _('Right CB Panel')}},


----------------------------------------------
--				TEST FEATURE!!!				--
-- Weapon/CMDS Adjustment
{	down = weapons_commands.ChangeHighCapRate,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1,	name = _('Change LAU-3/-60 Firing Rate - Single/Ripple(17.2ms)/Ripple(60ms)'),		category = {_('Ground Adjustment')}},
{	down = weapons_commands.ChangeLowCapRate,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1,	name = _('Change LAU-68 Firing Rate - Single/Ripple(60ms)'),						category = {_('Ground Adjustment')}},
{	down = cmds_commands.ChangeChaffBurst,			cockpit_device_id = devices.CMDS,				value_down = 1,	name = _('Change Chaff Burst Count - 1/2/3/4/6/8'),									category = {_('Ground Adjustment')}},
{	down = cmds_commands.ChangeChaffSalvo,			cockpit_device_id = devices.CMDS,				value_down = 1,	name = _('Change Chaff Salvo Count - 1/2/4/8/C'),									category = {_('Ground Adjustment')}},
{	down = cmds_commands.ChangeChaffBurstIntv,		cockpit_device_id = devices.CMDS,				value_down = 1,	name = _('Change Chaff Burst Interval (seconds) - 0.1/0.2/0.3/0.4'),				category = {_('Ground Adjustment')}},
{	down = cmds_commands.ChangeChaffSalvoIntv,		cockpit_device_id = devices.CMDS,				value_down = 1,	name = _('Change Chaff Salvo Interval (seconds) - 1/2/3/4/5/8/R'),					category = {_('Ground Adjustment')}},
{	down = cmds_commands.ChangeFlareBurst,			cockpit_device_id = devices.CMDS,				value_down = 1,	name = _('Change Flare Burst Count - 1/2/4/8/C'),									category = {_('Ground Adjustment')}},
{	down = cmds_commands.ChangeFlareBurstIntv,		cockpit_device_id = devices.CMDS,				value_down = 1,	name = _('Change Flare Burst Interval (seconds) - 3/4/6/8/10'),						category = {_('Ground Adjustment')}},
{	down = weapons_commands.ChangeLaserCode100,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1,	name = _('Change Laser Code, Hundreds (1..8)'),		category = {_('Ground Adjustment')}},
{	down = weapons_commands.ChangeLaserCode10,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1,	name = _('Change Laser Code, Tens (1..8)'),			category = {_('Ground Adjustment')}},
{	down = weapons_commands.ChangeLaserCode1,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down = 1,	name = _('Change Laser Code, Ones (1..8)'),			category = {_('Ground Adjustment')}},
----------------------------------------------

})

-- joystick axes 
join(res.axisCommands,{
{	action = iCommandPlaneRoll,			name = _('Roll')},
{	action = iCommandPlanePitch,		name = _('Pitch')},
{	action = iCommandPlaneRudder,		name = _('Rudder')},
{	action = iCommandPlaneThrustCommon,	name = _('Thrust')},
{combos = {{key = "JOY_RZ"}},	action = iCommandPlaneThrustLeft,	name = _('Thrust Left')},
{combos = {{key = "JOY_Z"}},	action = iCommandPlaneThrustRight,	name = _('Thrust Right')},

{action = iCommandWheelBrake,		name = _('Wheel Brake')},
{action = iCommandLeftWheelBrake,	name = _('Wheel Brake Left')},
{action = iCommandRightWheelBrake,	name = _('Wheel Brake Right')},

-- Left Vertical Panel
{action = intlights_commands.ArmtPanel_knob_AXIS,	cockpit_device_id = devices.INTLIGHTS_SYSTEM,	name = _('Armament Panel Lights Knob'),		category = {_('Left Vertical Panel')}},
{action = weapons_commands.MissileVolume_AXIS,		cockpit_device_id = devices.WEAPONS_CONTROL,	name = _('Missile Volume Knob'),			category = {_('Left Vertical Panel')}},

-- Left Panels
{action = control_commands.RudderTrim_AXIS,				cockpit_device_id = devices.CONTROL_INTERFACE,	name = _('Rudder Trim Knob'),				category = _('Left Panels')},

-- Right Vertical Panel
{action = ecs_commands.CabinTempKnob_AXIS,			cockpit_device_id = devices.ECS_INTERFACE,		name = _('Cabin Temperature Knob'),			category = {_('Right Vertical Panel')}},
{action = ecs_commands.CanopyDefog_AXIS,			cockpit_device_id = devices.ECS_INTERFACE,		name = _('Canopy Defog Knob'),				category = {_('Right Vertical Panel')}},

-- Right Panels
{action = extlights_commands.NavKnob_AXIS,			cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	name = _('Exterior Lights Nav Knob'),		category = {_('Right Panels'), _('Lighting Control Panel')}},
{action = extlights_commands.Formation_AXIS,		cockpit_device_id = devices.EXTLIGHTS_SYSTEM,	name = _('Exterior Lights Formation Knob'),	category = {_('Right Panels'), _('Lighting Control Panel')}},

{action = intlights_commands.Flood_knob_AXIS,		cockpit_device_id = devices.INTLIGHTS_SYSTEM,	name = _('Flood Lights Knob'),				category = {_('Right Panels'), _('Lighting Control Panel')}},
{action = intlights_commands.FltInstr_knob_AXIS,	cockpit_device_id = devices.INTLIGHTS_SYSTEM,	name = _('Flight Instruments Lights Knob'),	category = {_('Right Panels'), _('Lighting Control Panel')}},
{action = intlights_commands.EngInstr_knob_AXIS,	cockpit_device_id = devices.INTLIGHTS_SYSTEM,	name = _('Engine Instruments Lights Knob'),	category = {_('Right Panels'), _('Lighting Control Panel')}},
{action = intlights_commands.Console_knob_AXIS,		cockpit_device_id = devices.INTLIGHTS_SYSTEM,	name = _('Console Lights Knob'),			category = {_('Right Panels'), _('Lighting Control Panel')}},

-- AN/APQ-159 Radar Control Panel
{combos = {{key = "JOY_SLIDER1"}},	action = iCommandPlaneRadarVerticalAbs,		name = _("AN/APQ-159 Radar Elevation Antenna Tilt Control"),	category = _("AN/APQ-159 Radar Control Panel")},
{combos = {{key = "JOY_X"}},		action = apq159_commands.TDCAzimuth,				cockpit_device_id = devices.AN_APQ159,			name = _('AN/APQ-159 Radar TDC Button - Azimuth'),			category = _('AN/APQ-159 Radar Control Panel')},
{combos = {{key = "JOY_Y"}},		action = apq159_commands.TDCRange,					cockpit_device_id = devices.AN_APQ159,			name = _('AN/APQ-159 Radar TDC Button - Range'),			category = _('AN/APQ-159 Radar Control Panel')},
{action = apq159_commands.ScaleKnob_AXIS,			cockpit_device_id = devices.AN_APQ159,			name = _('AN/APQ-159 Radar Scale Knob'),					category = _('AN/APQ-159 Radar Control Panel')},
{action = apq159_commands.BrightKnob_AXIS,			cockpit_device_id = devices.AN_APQ159,			name = _('AN/APQ-159 Radar Bright Knob'),					category = _('AN/APQ-159 Radar Control Panel')},
{action = apq159_commands.PerKnob_AXIS,				cockpit_device_id = devices.AN_APQ159,			name = _('AN/APQ-159 Radar Persistence Knob'),				category = _('AN/APQ-159 Radar Control Panel')},
{action = apq159_commands.VideoKnob_AXIS,			cockpit_device_id = devices.AN_APQ159,			name = _('AN/APQ-159 Radar Video Knob'),					category = _('AN/APQ-159 Radar Control Panel')},
{action = apq159_commands.CursorKnob_AXIS,			cockpit_device_id = devices.AN_APQ159,			name = _('AN/APQ-159 Radar Cursor Knob'),					category = _('AN/APQ-159 Radar Control Panel')},
{action = apq159_commands.PitchKnob_AXIS,			cockpit_device_id = devices.AN_APQ159,			name = _('AN/APQ-159 Radar Pitch Knob'),					category = _('AN/APQ-159 Radar Control Panel')},

-- AN/ASG-31 Sight
{action = asg31_commands.RetIntensity_AXIS,			cockpit_device_id = devices.AN_ASG31,			name = _('AN/ASG-31 Sight Reticle Intensity Knob'),			category = _('AN/ASG-31 Sight')},
{action = asg31_commands.RetDepression_AXIS,		cockpit_device_id = devices.AN_ASG31,			name = _('AN/ASG-31 Sight Reticle Depression Knob'),		category = _('AN/ASG-31 Sight')},

-- RWR-IC
{action = ic_commands.Volume_AXIS,					cockpit_device_id = devices.RWR_IC,				name = _('RWR Indicator Control AUDIO Knob'),				category = {_('Instrument Panel'), _('RWR')}},
{action = ic_commands.Brightness_AXIS,				cockpit_device_id = devices.RWR_IC,				name = _('RWR Indicator Control DIM Knob'),					category = {_('Instrument Panel'), _('RWR')}},

-- AN/ALR-87 RWR
{action = alr87_commands.Brightness_AXIS,			cockpit_device_id = devices.AN_ALR87,			name = _('RWR Indicator INT Knob'),							category = {_('Instrument Panel'), _('RWR')}},

-- Attitude Indicator ARU-20
{action = aru20_commands.AI_PITCH_TRIM_AXIS,		cockpit_device_id = devices.AI_ARU20,			name = _('AI Pitch Trim Knob'),								category = _('Instrument Panel')},

-- Standby Attitude Indicator
{action = sai_commands.CMD_SAI_PITCH_AXIS,			cockpit_device_id = devices.SAI,				name = _('SAI Cage/Pitch Trim Knob'),						category = _('Instrument Panel')},

--UHF Radio AN/ARC-164
{action = device_commands.Button_25,				cockpit_device_id = devices.UHF_RADIO,			name = _('UHF Radio Volume Knob - CCW/Decrease'),			category = {_('UHF Radio ARC-164 Control Panel'), _('Pedestal Panels')}},

--TACAN
{action = device_commands.Button_8, 				cockpit_device_id = devices.TACAN,				name = _('TACAN Volume'),									category = {_('ARN-118 TACAN Control Panel'), _('Pedestal Panels')}},
})

return res
